% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapter-httr.R
\docType{data}
\name{HttrAdapter}
\alias{HttrAdapter}
\title{httr library adapter}
\description{
httr library adapter
}
\details{
\strong{Methods}
\describe{
\item{\code{enable()}}{
Enable the adapter
}
\item{\code{disable()}}{
Disable the adapter
}
\item{\code{build_httr_request(x)}}{
Build a httr \link{RequestSignature}
x: httr request parts (list)
}
\item{\code{build_httr_response(req, resp)}}{
Build a httr response
req: a httr request (list)
resp: a httr response ()
}
\item{\code{handle_request()}}{
All logic for handling a request
req: a httr request (list)
}
\item{\code{remove_httr_stubs()}}{
Remove all httr stubs
}
}

This adapter modifies \pkg{httr} to allow mocking HTTP requests
}
\examples{
\dontrun{
library(httr)

# normal httr request, works fine
real <- GET("https://httpbin.org/get")
real

# with webmockr
library(webmockr)
## turn on httr mocking
httr_mock()
## now this request isn't allowed
# GET("https://httpbin.org/get")
## stub the request
stub_request('get', uri = 'https://httpbin.org/get') \%>\%
  wi_th(
    headers = list('Accept' = 'application/json, text/xml, application/xml, */*')
  ) \%>\%
  to_return(status = 418, body = "I'm a teapot!", headers = list(a = 5))
## now the request succeeds and returns a mocked response
(res <- GET("https://httpbin.org/get"))
res$status_code
rawToChar(res$content)

# allow real requests while webmockr is loaded
webmockr_allow_net_connect()
webmockr_net_connect_allowed()
GET("https://httpbin.org/get?animal=chicken")
webmockr_disable_net_connect()
webmockr_net_connect_allowed()
# GET("https://httpbin.org/get?animal=chicken")
}
}
\seealso{
Other http_lib_adapters: \code{\link{CrulAdapter}}
}
\concept{http_lib_adapters}
\keyword{datasets}
