% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs.R
\name{srs_query}
\alias{srs_query}
\title{Get record details from U.S. EPA Substance Registry Servives (SRS)}
\usage{
srs_query(
  query,
  from = c("itn", "cas", "epaid", "tsn", "name"),
  verbose = getOption("verbose"),
  ...
)
}
\arguments{
\item{query}{character; query ID.}

\item{from}{character; type of query ID, e.g. \code{'itn'} , \code{'cas'},
\code{'epaid'}, \code{'tsn'}, \code{'name'}.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{not currently used.}
}
\value{
a list of lists (for each supplied query): a list of 22. subsKey,
 internalTrackingNumber, systematicName, epaIdentificationNumber,
 currentCasNumber, currentTaxonomicSerialNumber, epaName, substanceType,
 categoryClass, kingdomCode, iupacName, pubChemId, molecularWeight,
 molecularFormula, inchiNotation, smilesNotation, classifications,
 characteristics, synonyms, casNumbers, taxonomicSerialNumbers, relationships
}
\description{
Get record details from SRS, see \url{https://cdxnodengn.epa.gov/cdx-srs-rest/}
}
\examples{
\dontrun{
# might fail if API is not available
srs_query(query = '50-00-0', from = 'cas')

### multiple inputs
casrn <- c('50-00-0', '67-64-1')
srs_query(query = casrn, from = 'cas')
}
}
