% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{with_cts}
\alias{with_cts}
\title{Auto-translate identifiers and search databases}
\usage{
with_cts(query, from, .f, .verbose = TRUE, ...)
}
\arguments{
\item{query}{character; the search term}

\item{from}{character; the format or type of query.  Commonly accepted values
are "name", "cas", "inchi", and "inchikey"}

\item{.f}{character; the (quoted) name of a webchem function}

\item{.verbose}{logical; print a message when translating query?}

\item{...}{other arguments passed to the function specified with \code{.f}}
}
\value{
returns results from \code{.f}
}
\description{
Supply a query of any type (e.g. SMILES, CAS, name, InChI, etc.) along with
any webchem function that has \code{query} and \code{from} arguments.  If the
function doesn't accept the type of query you've supplied, this will try to
automatically translate it using CTS and run the query.
}
\note{
During the translation step, only the first hit from CTS is used.
  Therefore, using this function to translate on the fly is not foolproof and
  care should be taken to verify the results.
}
\examples{
\dontrun{
with_cts("XDDAORKBJWWYJS-UHFFFAOYSA-N", from = "inchikey", .f = "get_etoxid")
}
}
