% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alanwood.R
\name{aw_query}
\alias{aw_query}
\title{Query http://www.alanwood.net/pesticides/}
\usage{
aw_query(query, from = c("name", "cas"), verbose = TRUE, type, ...)
}
\arguments{
\item{query}{character; search string}

\item{from}{character; type of input ('cas' or 'name')}

\item{verbose}{logical; print message during processing to console?}

\item{type}{deprecated}

\item{...}{additional arguments to internal utility functions}
}
\value{
A list of eight entries: common-name, status, preferred IUPAC Name,
IUPAC Name, cas, formula, activity, subactivity, inchikey, inchi and source
url.
}
\description{
Query Alan Woods Compendium of Pesticide Common Names
\url{http://www.alanwood.net/pesticides/}
}
\note{
for from = 'cas' only the first matched link is returned.
Please respect Copyright, Terms and Conditions
\url{http://www.alanwood.net/pesticides/legal.html}!
}
\examples{
\dontrun{
aw_query('Fluazinam', from = 'name')
out <- aw_query(c('Fluazinam', 'Diclofop'), from = 'name')
out
# extract subactivity from object
sapply(out, function(y) y$subactivity[1])

# use CAS-numbers
aw_query("79622-59-6", from = 'cas')
}
}
\references{
Eduard Szöcs, Tamás Stirling, Eric R. Scott, Andreas Scharmüller,
Ralf B. Schäfer (2020). webchem: An R Package to Retrieve Chemical
Information from the Web. Journal of Statistical Software, 93(13).
\doi{10.18637/jss.v093.i13}.
}
