% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikidata.R
\name{wd_ident}
\alias{wd_ident}
\title{Retrieve Indentifiers from wikidata}
\usage{
wd_ident(id, verbose = TRUE)
}
\arguments{
\item{id}{character; identifier, as returned by \code{\link{get_wdid}}}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A list of identifiers. Currently these are 'smiles', 'cas', 'cid', 'einecs', 'csid', 'inchi', 'inchikey',
'drugbank', 'zvg', 'chebi', 'chembl', 'unii' and source_url.
}
\description{
Retrieve Indentifiers from wikidata
}
\note{
Only matches in labels are returned.
}
\examples{
\dontrun{
 id <- "Q408646" # Triclosan
 wd_ident(id)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\references{
Willighagen, E., 2015. Getting CAS registry numbers out of WikiData. The Winnower.
\url{http://dx.doi.org/10.15200/winn.142867.72538}

Mitraka, Elvira, Andra Waagmeester, Sebastian Burgstaller-Muehlbacher, et al. 2015
Wikidata: A Platform for Data Integration and Dissemination for the Life Sciences and beyond. bioRxiv: 031971.
}
\seealso{
\code{\link{get_wdid}}
}

