\name{getSummarizedWeather}
\alias{getSummarizedWeather}
\title{Gets daily summary weather data (One record per day)}
\usage{
getSummarizedWeather(station_id, start_date, end_date = NULL,
  station_type = "airportCode", opt_temperature_columns = TRUE,
  opt_all_columns = FALSE, opt_custom_columns = FALSE,
  custom_columns = NULL, opt_verbose = FALSE)
}
\arguments{
  \item{station_id}{is a valid 3-letter airport code or a
  valid Weather Station ID}

  \item{start_date}{string representing a date in the past
  ("YYYY-MM-DD")}

  \item{end_date}{(optional) string representing a date in
  the past ("YYYY-MM-DD"), and later than or equal to
  start_date.}

  \item{station_type}{can be \code{airportCode} which is
  the default, or it can be \code{id} which is a
  weather-station ID}

  \item{opt_temperature_columns}{Boolen flag to indicate
  only Temperature data is to be returned (default TRUE)}

  \item{opt_all_columns}{Boolen flag to indicate whether
  all available data is to be returned (default FALSE)}

  \item{opt_custom_columns}{Boolen flag to indicate if only
  a user-specified set of columns are to be returned.
  (default FALSE) If TRUE, then the desired columns must be
  specified via \code{custom_columns}}

  \item{custom_columns}{Vector of integers specified by the
  user to indicate which columns to fetch.  The Date column
  is always returned as the first column. The column
  numbers specfied in \code{custom_columns} are appended as
  columns of the data frame being returned (default NULL).
  The exact column numbers can be found by visiting the
  weatherUnderground URL, and counting from 1. Note that if
  \code{opt_custom_columns} is TRUE, then
  \code{custom_columns} must be specified.}

  \item{opt_verbose}{Boolean flag to indicate if verbose
  output is desired}
}
\value{
A data frame with each row containing: \itemize{ \item Date
stamp for the date specified \item Additional columns of
Weather data depending on the options specified }
}
\description{
Given a valid station and a single date this function will
return a dataframe of time-stamped weather data. All the
records are summarized into one record per day. If and
\code{end_date} is specified the function returns 1 record
for each day in the date range.
}
\examples{
\dontrun{
paris_in_fall<- getSummarizedWeather("CDG", "2013-09-30") #will get Temp columns by default
#
windLHR <- getSummarizedWeather("LHR", "2012-12-12", "2012-12-31",
                                 opt_custom_columns=TRUE,
                                 custom_columns=c(17,18,19,23))

}
}
\seealso{
getWeatherForDate, getDetailededWeather
}

