% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa_control.R
\name{rpa_control_newedge}
\alias{rpa_control_newedge}
\title{Control new edges in each step. Defined for \code{rpanet}.}
\usage{
rpa_control_newedge(
  distribution = NULL,
  dparams = NULL,
  shift = 1,
  snode.replace = TRUE,
  tnode.replace = TRUE,
  node.replace = TRUE
)
}
\arguments{
\item{distribution}{Distribution for drawing number of new edges. Default is
\code{NULL}. If specified, its first argument must be the number of
observations.}

\item{dparams}{A list of parameters passed on to \code{distribution}. The
name of parameters must be specified.}

\item{shift}{A constant added to the values sampled from \code{distribution}.
Default value is 1.}

\item{snode.replace}{Logical. Determines whether the source nodes in the same
step should be sampled with replacement. Defined for directed networks.}

\item{tnode.replace}{Logical. Determines whether the target nodes in the same
step should be sampled with replacement. Defined for directed networks.}

\item{node.replace}{Logical. Determines whether the nodes in the same step
should be sampled with replacement. Defined for undirected networks. If
FALSE, self-loops will not be allowed under beta scenario.}
}
\value{
A list of class \code{rpacontrol} with components
  \code{distribution}, \code{dparams}, \code{shift}, \code{snode.replace},
  \code{tnode.replace} and \code{node.replace} with meanings as explained
  under 'Arguments'.
}
\description{
Control new edges in each step. Defined for \code{rpanet}.
}
\examples{
control <- rpa_control_newedge(
  distribution = rpois,
  dparams = list(lambda = 2),
  shift = 1,
  node.replace = FALSE
)
}
