% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_require.R
\name{wb_require}
\alias{wb_require}
\title{Use Packages from Way-Back-Then}
\usage{
wb_require(
  pkg,
  library_path = getOption("wb_require_lib_path", NULL),
  date = getOption("wb_require_date", NULL),
  date_shift = getOption("wb_require_shift_date", NULL),
  package_path = getOption("wb_require_package_path", NULL),
  dependencies = getOption("wb_require_dependencies", c("Depends", "Imports",
    "LinkingTo")),
  url_fun = getOption("wb_require_url", wb_repo_url)
)
}
\arguments{
\item{pkg}{\code{character} - package name specified as cha}

\item{library_path}{\code{character} - lib_path to use first}

\item{date}{\code{character} - date specified in ISO format, defaults to date
specified in \code{sessionInfo()$R.version$version.string}}

\item{date_shift}{\code{integer} - number of days to add to date}

\item{package_path}{\code{character} - path to look for binary packages to install}

\item{dependencies}{\verb{character vector} - specifies which types of dependencies
should be installed also}

\item{url_fun}{function transforming a date into a repository url}
}
\description{
This function will make sure a specified package is available within the
current R session. If the package is not available it will attempt to
install it and load it thereafter. If its already installed it will only
load the package.
}
\details{
Other than the normal \code{install.packages} function this function will not
use the newest package available but one that was available at a specific
point in time on CRAN. For CRAN snapshots the Microsoft R Open snapshots and
the checkpoint package are used.

The default date is the date of the release of the R version currently in use
plus an additional 60 days.

The \code{lib_path} argument can be used to make use a project specific
R package library path.

Also, its possible to specify a path were binary packages can be found and
installed from.
}
\examples{

\dontrun{

# set options
options(wb_require_lib_path = "./r_lib_path")

# make sure package is available
wb_require("data.table")

# use packages released up to 365 days younger than the current R-versions
# release date
wb_require("data.table", date_shift = 365)

# use a specific lib path for loading and installing
wb_require("data.table", lib_path = "./r_lib_path")

}

}
