% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integral.R
\name{integral}
\alias{integral}
\title{integral}
\usage{
integral(
  y,
  smooth = TRUE,
  rescale = TRUE,
  thres = 0.2,
  width = 3,
  tr = 1,
  dis = 20
)
}
\arguments{
\item{y}{is the waveform intensities. If you have other information, you should delete these intensites before you run this function .}

\item{smooth}{is tell whether you want to smooth the waveform to reduce the effect of some obvious noise. Default is TRUE.}

\item{rescale}{is to determine whether you want to rescale the waveform intensity or not. Here we used the minimum intensity of each waveform to conduct rescaling.
Default is using rescaling.}

\item{thres}{is to determine if the detected peak is the real peak whose intensity should be higher than threshold*maximum intensity.
Default is 0.2.}

\item{width}{width of moving window.Default is 3, must be integer between 1 and n.This parameter ONLY work when the smooth is TRUE.}

\item{tr}{the temporal resolution of waveform.Default is 1 ns. Must be integer from 1 to n.}

\item{dis}{the distance from last echo (assumed ground) which determine the boundary between ground and vegetation.
Default is 20 ns which equals to 3 m (20*0.15*1).This means the ground part signals are from
the assumed ground location to 20 ns above or the signals of vegetation are from waveform begining to 3 m above ground.}
}
\value{
return the integral of waveform intensity for the ground, vegetation parts, the whole waveform above ground
       and the integral ration betwwen vegetation and the whole waveform .
}
\description{
The function allows you to calculate the integral of intensity from ground part, vegetation part, sum of them
and ratio between vegation integral and total integral with user-defined vegetation and ground boundary.
}
\examples{

data(return)
x<-return[1,]
##if we kept everything as default, before you use this function, you need to know the
## temporal resolution of waveform, default is 1 ns.

##for one peak, it generaly not make too much sense since generally only ground was
##present in this case.

r1<-integral(x)

#if you didn't want to smooth,
r2<-integral(x,smooth=FALSE)

##you also can define the boundary between vegetation and ground by assign adjusting dis
#if we assign 15, it means vegetation starts at 2.25 (15*1*0.15) m above the last echo.

r3<-integral(x,dis=15)
# when it comes to the waveform with several peaks
xx<-return[182,]

rr1<-integral(xx)

}
