% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/med.height.R
\name{med.height}
\alias{med.height}
\title{med.height}
\usage{
med.height(x, smooth = TRUE, thres = 0.2, width = 3, tr = 1)
}
\arguments{
\item{x}{is the waveform intensities. If you have other information, you should delete these intensites before you run this function .}

\item{smooth}{is tell whether you want to smooth the waveform to reduce the effect of some obvious noise. Default is TRUE.}

\item{thres}{is to determine if the detected peak is the real peak whose intensity should be higher than threshold*maximum intensity. Default is 0.22.}

\item{width}{width of moving window.Default is 3, must be integer between 1 and n.This parameter ONLY work when the smooth is TRUE.}

\item{tr}{the temporal resolution of waveform.Default is 1 ns. Must be integer from 1 to n.}
}
\value{
return the height of half total energy above the ground and
        the height proportion of the first half (from waveform begining to the half total energy position).
}
\description{
The function allows you to calculate the height of half total energy above ground (not total waveform) and height proportion at the half energy position.
If you are interested in variables from the total waveform, you can use which.half or percentile.location functions.
}
\examples{

data(return)
x<-return[1,]
#default
med.height(x)  ###for one peak waveform, it generally not make too much sense
xx<-return[182,]
med.height(xx)  ##this can help to charcterize the waveform
}
