% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importDVs.R
\name{tellMeSiteURL}
\alias{tellMeSiteURL}
\title{USGS Site Information Service URL}
\usage{
tellMeSiteURL(staid)
}
\arguments{
\item{staid}{is the USGS site identification number, which 
is usually eight digits long, but can be longer.  Users may search for 
surface-water sites and obtain station identification numbers using the 
USGS Site Web Service, 
\url{https://waterservices.usgs.gov/rest/Site-Service.html} (U.S. Geological 
Survey, 2017b); using the National Water Information System: Mapper, 
\url{https://maps.waterdata.usgs.gov/mapper/index.html} (U.S. Geological Survey, 2017a); 
or using the National Water Information System: Web Interface to daily 
surface-water data, 
\url{https://waterdata.usgs.gov/nwis/dv/?referred_module=sw} (U.S. 
Geological Survey, 2017c).  The site identification number needs to be 
entered as a character, that is in quotes, because many USGS streamgage 
numbers begin with zero and the leading zero is necessary.}
}
\value{
URL for USGS site information
}
\description{
Function that returns USGS Site Information Service URL for troubleshooting or 
building a URL for other purposes.
}
\examples{
tellMeSiteURL("05054000")
}
\references{
U.S. Geological Survey, 2017a, National Water Information System: Mapper, 
accessed January 3, 2017, at 
\url{https://maps.waterdata.usgs.gov/mapper/index.html}.

U.S. Geological Survey, 2017b, USGS site web service: 
REST Web Services, accessed January 3, 2017, at 
\url{https://waterservices.usgs.gov/rest/Site-Service.html}.

U.S. Geological Survey, 2017c, USGS surface-water daily data for the Nation: 
National Water Information System: Web Interface, accessed January 3, 2017, 
at \url{https://waterdata.usgs.gov/nwis/dv/?referred_module=sw}.
}
\keyword{utilities}

