% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_sensibleHeatFlux.R
\name{calcAnchors}
\alias{calcAnchors}
\title{Select anchors pixels for H function}
\usage{
calcAnchors(image, Ts, LAI, albedo, Z.om, n = 1, aoi,
  anchors.method = "flexible", WeatherStation, plots = TRUE,
  deltaTemp = 5, minDist = 500, WSbuffer = 30000, verbose = FALSE)
}
\arguments{
\item{image}{top-of-atmosphere landsat reflectance image}

\item{Ts}{land surface temperature in K. See surfaceTemperature()}

\item{LAI}{rasterLayer with Leaf Area Index. See LAI()}

\item{albedo}{broandband surface albedo. See albedo()}

\item{Z.om}{momentum roughness lenght. See momentumRoughnessLength()}

\item{n}{number of pair of anchors pixels to calculate}

\item{aoi}{area of interest to limit the search. If 
waterOptions(autoAOI) == TRUE, It'll use aoi object from .GlobalEnv}

\item{anchors.method}{method for the selection of anchor pixels. "random" for
random selection of hot and cold candidates according to CITRA-MCB method, or 
"best" for selecting the best candidates. And "flexible" for method with soft
limits to the anchor pixel conditions.}

\item{WeatherStation}{Optional. WeatherStation data at the satellite overpass. 
Should be a waterWeatherStation object calculated using read.WSdata and MTL file.}

\item{plots}{Logical. If TRUE will plot position of anchors points
selected. Points in red are selected hot pixels, blue are the cold ones and the 
black represents the position of the Weather Station}

\item{deltaTemp}{deltaTemp for method "CITRA-MCBs" or "CITRA-MCBr"}

\item{minDist}{minimun distance allowed for two anchor pixels of the 
same type (in meters).}

\item{WSbuffer}{maximun distante to the Weather Station (in meters).}

\item{verbose}{Logical. If TRUE will print aditional data to console}
}
\description{
automatically search end members within the satellite scene (extreme wet and dry conditions).
}
\references{
CITRA y MCB (com pers)
}
\seealso{
Other sensible heat flux functions: \code{\link{calcH}},
  \code{\link{momentumRoughnessLength}}
}
\author{
Guillermo Federico Olmedo

de la Fuente-Saiz, Daniel
}
