% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_est.R
\name{resample_est}
\alias{resample_est}
\title{Resample wave objects in a extended selection table}
\usage{
resample_est(
  X,
  samp.rate = 44.1,
  bit.depth = 16,
  avoid.clip = TRUE,
  pb = FALSE,
  parallel = 1
)
}
\arguments{
\item{X}{object of class 'extended_selection_table' (see \code{\link{selection_table}}).}

\item{samp.rate}{Numeric vector of length 1 with the sampling rate (in kHz) for output files. Default is \code{NULL}.}

\item{bit.depth}{Numeric vector of length 1 with the dynamic interval (i.e. bit depth) for output files.}

\item{avoid.clip}{Logical to control whether the volume is automatically
adjusted to avoid clipping high amplitude samples when resampling. Ignored if
 '\code{sox = FALSE}. Default is \code{TRUE}.}

\item{pb}{Logical argument to control progress bar. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}
}
\value{
An extended selection table with the modified wave objects.
}
\description{
\code{resample_est} changes sampling rate and bit depth of wave objects in a extended selection table.
}
\details{
This function aims to simplify the process of homogenizing sound
files (sampling rate and bit depth). This is a necessary step before running
any further (bio)acoustic analysis. \href{https://sourceforge.net/projects/sox/}{SOX} must be installed.
}
\examples{
\dontrun{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

# create extended selection table
X <- selection_table(
  X = lbh_selec_table, extended = TRUE, pb = FALSE,
  path = tempdir()
)

# resample
Y <- resample_est(X)
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{mp32wav}}, \code{\link{fix_wavs}}

Other extended selection table manipulation: 
\code{\link{by_element_est}()},
\code{\link{rename_est_waves}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
#last modification on oct-15-2018 (MAS)
}
\concept{extended selection table manipulation}
