% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xfer_mess.R
\name{xfer_mess}
\alias{xfer_mess}
\title{xfer_mess generate MESS map for transferred raster}
\usage{
xfer_mess(occs, bg, bgMsk, xferExtRas, logger = NULL, spN = NULL)
}
\arguments{
\item{occs}{a data frame of occurrences used for modeling and values of
environmental variables for each point.}

\item{bg}{a data frame of points used as background for modeling and values
of environmental variables for each point.}

\item{bgMsk}{a rasterBrick or rasterStack of environmental variables used
for modeling. They must be cropped and masked to extent used in model
training.}

\item{xferExtRas}{a rasterStack or rasterBrick of environmental variables
to be used for transferring.}

\item{logger}{Stores all notification messages to be displayed in the Log
Window of Wallace GUI. Insert the logger reactive list here for running
in shiny, otherwise leave the default NULL.}

\item{spN}{character. Used to obtain species name for logger messages}
}
\description{
This function generates a MESS map for the new variables for
transferring based on variables and points used for modeling in previous
components.
}
\details{
This functions allows for the creation of a MESS map for the new provided
variables for transferring. These variables are either user uploaded or
selected from WorldClim database. MESS map is based on occurrence and
background points used for generating the model and the environmental values
at those points.
}
\examples{
\dontrun{
envs <- envs_userEnvs(rasPath = list.files(system.file("extdata/wc",
                                           package = "wallace"),
                      pattern = ".tif$", full.names = TRUE),
                      rasName = list.files(system.file("extdata/wc",
                                           package = "wallace"),
                      pattern = ".tif$", full.names = FALSE))
# load model
m <- readRDS(system.file("extdata/model.RDS",
                         package = "wallace"))
occsEnvs <- m@occs
bgEnvs <- m@bg
envsFut <- list.files(path = system.file('extdata/wc/future',
                                         package = "wallace"),
                      full.names = TRUE)
envsFut <- raster::stack(envsFut)
## run function
xferMess <- xfer_mess(occs = occsEnvs, bg = bgEnvs, bgMsk = envs,
                      xferExtRas = envsFut)
}
}
\seealso{
\code{\link[dismo]{mess}}, \code{\link{xfer_time}}
\code{\link{xfer_userEnvs}}
}
\author{
Jamie Kass <jkass@gradcenter.cuny.edu>

Gonzalo E. Pinilla-Buitrago <gepinillab@gmail.com>
}
