% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xfer_time.R
\name{xfer_time}
\alias{xfer_time}
\title{xfer_time Transfer model to a new time}
\usage{
xfer_time(
  evalOut,
  curModel,
  envs,
  xfExt,
  alg,
  outputType = NULL,
  clamp = NULL,
  logger = NULL,
  spN = NULL
)
}
\arguments{
\item{evalOut}{ENMevaluate output from previous module and using any of
the available algorithms.}

\item{curModel}{if algorithm is maxent, model selected by user as best
or optimal, in terms of feature class and regularization multiplier (e.g
'L_1'). Otherwise must be 1.}

\item{envs}{environmental layers of different time to be used for transferring
the model. They must match the layers used for generating the model in the
model component.}

\item{xfExt}{extent of the area to transfer the model. This is defined by the
user in the map of the GUI and is provided as a SpatialPolygons object.}

\item{alg}{modeling algorithm used in the model component. Can be one of:
'bioclim', 'maxent.jar' or 'maxnet'.}

\item{outputType}{output type to be used when algorithm is maxnet or
maxent.jar.}

\item{clamp}{logical. Whether transfer will be of clamped or unclamped
model.}

\item{logger}{Stores all notification messages to be displayed in the Log
Window of Wallace GUI. Insert the logger reactive list here for running in
shiny, otherwise leave the default NULL.}

\item{spN}{character. Used to obtain species name for logger messages.}
}
\value{
A list of two elements: xferExt and xferTime. The first is a
  RasterBrick or RasterStack of the environmental variables cropped to the
  area of transfer. The second element is a raster of the transferred model
  with the specified output type.
}
\description{
Function transfers the model generated in previous components to
  a new time and area using provided layers.
}
\details{
This functions allows transferring the model created in previous
  components to a new time and area. The area of transfer is user provided in
  the map of the GUI and the transfer time user selected. The model will
  be transferred to the new area and time as long as the environmental
  variables are available for the area. This function returns a list
  including the cropped environmental variables used for transferring and
  the transferred model.
}
\examples{
\dontrun{
envs <- envs_userEnvs(rasPath = list.files(system.file("extdata/wc",
                                                       package = "wallace"),
                                           pattern = ".tif$",
                                           full.names = TRUE),
                      rasName = list.files(system.file("extdata/wc",
                                                       package = "wallace"),
                                           pattern = ".tif$",
                                           full.names = FALSE))
## extent to transfer
# set coordinates
longitude <- c(-71.58400, -78.81300, -79.34034, -69.83331, -66.47149, -66.71319,
               -71.11931)
latitude <- c(13.18379, 7.52315, 0.93105, -1.70167, 0.98391, 6.09208, 12.74980)
# generate matrix
selCoords <- matrix(c(longitude, latitude), byrow = FALSE, ncol = 2)
polyExt <- sp::SpatialPolygons(list(sp::Polygons(list(sp::Polygon(selCoords)),
                                                 ID = 1)))
# load model
m <- readRDS(system.file("extdata/model.RDS",
                         package = "wallace"))
occsEnvs <- m@occs
bgEnvs <- m@bg
envsFut <- list.files(path = system.file('extdata/wc/future',
                                         package = "wallace"),
                      full.names = TRUE)
envsFut <- raster::stack(envsFut)
modXfer <- xfer_time(evalOut = m, curModel = 1,
                     envs = envsFut, alg = 'maxent.jar',
                     xfExt = polyExt, clamp = FALSE, outputType = 'cloglog')
}
}
\seealso{
\code{\link[dismo]{predict}}, \code{\link{xfer_time}}
\code{\link{xfer_userEnvs}}
}
\author{
Jamie Kass <jkass@gradcenter.cuny.edu>

Andrea Paz <paz.andreita@gmail.com>

Gonzalo E. Pinilla-Buitrago <gepinillab@gmail.com>
}
