// Generated by rstantools.  Do not edit by hand.

/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
#ifndef USE_STANC3
#define USE_STANC3
#endif
// Code generated by stanc v2.26.1
#include <stan/model/model_header.hpp>
namespace model_rw1_model_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 74, column 2 to column 27)",
                                                      " (in 'string', line 75, column 2 to column 24)",
                                                      " (in 'string', line 78, column 2 to column 21)",
                                                      " (in 'string', line 79, column 2 to column 22)",
                                                      " (in 'string', line 81, column 4 to column 31)",
                                                      " (in 'string', line 82, column 4 to column 32)",
                                                      " (in 'string', line 80, column 16 to line 83, column 3)",
                                                      " (in 'string', line 80, column 2 to line 83, column 3)",
                                                      " (in 'string', line 92, column 2 to column 18)",
                                                      " (in 'string', line 93, column 2 to column 20)",
                                                      " (in 'string', line 94, column 2 to column 22)",
                                                      " (in 'string', line 95, column 2 to column 28)",
                                                      " (in 'string', line 99, column 5 to column 55)",
                                                      " (in 'string', line 98, column 16 to line 100, column 3)",
                                                      " (in 'string', line 98, column 2 to line 100, column 3)",
                                                      " (in 'string', line 103, column 6 to column 56)",
                                                      " (in 'string', line 102, column 18 to line 104, column 5)",
                                                      " (in 'string', line 102, column 4 to line 104, column 5)",
                                                      " (in 'string', line 101, column 23 to line 105, column 3)",
                                                      " (in 'string', line 101, column 2 to line 105, column 3)",
                                                      " (in 'string', line 108, column 4 to column 73)",
                                                      " (in 'string', line 107, column 16 to line 109, column 3)",
                                                      " (in 'string', line 107, column 2 to line 109, column 3)",
                                                      " (in 'string', line 111, column 2 to column 104)",
                                                      " (in 'string', line 115, column 4 to column 77)",
                                                      " (in 'string', line 114, column 16 to line 116, column 3)",
                                                      " (in 'string', line 114, column 2 to line 116, column 3)",
                                                      " (in 'string', line 121, column 6 to column 58)",
                                                      " (in 'string', line 120, column 18 to line 122, column 5)",
                                                      " (in 'string', line 120, column 4 to line 122, column 5)",
                                                      " (in 'string', line 124, column 6 to column 84)",
                                                      " (in 'string', line 126, column 8 to column 66)",
                                                      " (in 'string', line 125, column 20 to line 127, column 7)",
                                                      " (in 'string', line 125, column 6 to line 127, column 7)",
                                                      " (in 'string', line 123, column 28 to line 128, column 5)",
                                                      " (in 'string', line 123, column 4 to line 128, column 5)",
                                                      " (in 'string', line 129, column 4 to column 94)",
                                                      " (in 'string', line 119, column 17 to line 130, column 3)",
                                                      " (in 'string', line 119, column 2 to line 130, column 3)",
                                                      " (in 'string', line 86, column 2 to column 45)",
                                                      " (in 'string', line 87, column 2 to column 45)",
                                                      " (in 'string', line 88, column 2 to column 87)",
                                                      " (in 'string', line 56, column 2 to column 17)",
                                                      " (in 'string', line 57, column 2 to column 17)",
                                                      " (in 'string', line 58, column 9 to column 10)",
                                                      " (in 'string', line 58, column 12 to column 13)",
                                                      " (in 'string', line 58, column 2 to column 20)",
                                                      " (in 'string', line 59, column 9 to column 10)",
                                                      " (in 'string', line 59, column 2 to column 14)",
                                                      " (in 'string', line 60, column 9 to column 10)",
                                                      " (in 'string', line 60, column 2 to column 22)",
                                                      " (in 'string', line 61, column 9 to column 10)",
                                                      " (in 'string', line 61, column 2 to column 20)",
                                                      " (in 'string', line 62, column 9 to column 14)",
                                                      " (in 'string', line 62, column 2 to column 27)",
                                                      " (in 'string', line 63, column 9 to column 14)",
                                                      " (in 'string', line 63, column 2 to column 25)",
                                                      " (in 'string', line 64, column 2 to column 21)",
                                                      " (in 'string', line 65, column 9 to column 10)",
                                                      " (in 'string', line 65, column 12 to column 17)",
                                                      " (in 'string', line 65, column 2 to column 28)",
                                                      " (in 'string', line 68, column 9 to column 10)",
                                                      " (in 'string', line 68, column 2 to column 42)",
                                                      " (in 'string', line 69, column 9 to column 10)",
                                                      " (in 'string', line 69, column 2 to column 38)",
                                                      " (in 'string', line 70, column 2 to column 36)",
                                                      " (in 'string', line 71, column 2 to column 32)",
                                                      " (in 'string', line 74, column 24 to column 25)",
                                                      " (in 'string', line 78, column 9 to column 10)",
                                                      " (in 'string', line 79, column 9 to column 10)",
                                                      " (in 'string', line 92, column 9 to column 10)",
                                                      " (in 'string', line 93, column 9 to column 10)",
                                                      " (in 'string', line 93, column 12 to column 13)",
                                                      " (in 'string', line 94, column 9 to column 14)",
                                                      " (in 'string', line 95, column 9 to column 10)",
                                                      " (in 'string', line 95, column 12 to column 17)",
                                                      " (in 'string', line 6, column 2 to column 18)",
                                                      " (in 'string', line 7, column 2 to column 19)",
                                                      " (in 'string', line 8, column 2 to column 20)",
                                                      " (in 'string', line 9, column 9 to column 10)",
                                                      " (in 'string', line 9, column 2 to column 19)",
                                                      " (in 'string', line 10, column 9 to column 10)",
                                                      " (in 'string', line 10, column 12 to column 13)",
                                                      " (in 'string', line 10, column 2 to column 35)",
                                                      " (in 'string', line 12, column 4 to column 42)",
                                                      " (in 'string', line 13, column 4 to column 46)",
                                                      " (in 'string', line 14, column 11 to column 12)",
                                                      " (in 'string', line 14, column 4 to column 36)",
                                                      " (in 'string', line 15, column 4 to column 15)",
                                                      " (in 'string', line 16, column 4 to column 27)",
                                                      " (in 'string', line 17, column 4 to column 41)",
                                                      " (in 'string', line 11, column 17 to line 18, column 3)",
                                                      " (in 'string', line 11, column 2 to line 18, column 3)",
                                                      " (in 'string', line 19, column 3 to column 17)",
                                                      " (in 'string', line 5, column 94 to line 20, column 3)",
                                                      " (in 'string', line 23, column 2 to column 18)",
                                                      " (in 'string', line 24, column 2 to column 19)",
                                                      " (in 'string', line 25, column 9 to column 10)",
                                                      " (in 'string', line 25, column 2 to column 19)",
                                                      " (in 'string', line 26, column 9 to column 10)",
                                                      " (in 'string', line 26, column 12 to column 13)",
                                                      " (in 'string', line 26, column 2 to column 35)",
                                                      " (in 'string', line 27, column 9 to column 10)",
                                                      " (in 'string', line 27, column 2 to column 14)",
                                                      " (in 'string', line 28, column 9 to column 10)",
                                                      " (in 'string', line 28, column 2 to column 14)",
                                                      " (in 'string', line 29, column 9 to column 10)",
                                                      " (in 'string', line 29, column 12 to column 13)",
                                                      " (in 'string', line 29, column 2 to column 17)",
                                                      " (in 'string', line 30, column 9 to column 10)",
                                                      " (in 'string', line 30, column 12 to column 15)",
                                                      " (in 'string', line 30, column 2 to column 19)",
                                                      " (in 'string', line 31, column 9 to column 10)",
                                                      " (in 'string', line 31, column 2 to column 17)",
                                                      " (in 'string', line 33, column 4 to column 40)",
                                                      " (in 'string', line 34, column 4 to column 44)",
                                                      " (in 'string', line 35, column 4 to column 34)",
                                                      " (in 'string', line 36, column 4 to column 23)",
                                                      " (in 'string', line 37, column 4 to column 40)",
                                                      " (in 'string', line 32, column 17 to line 38, column 3)",
                                                      " (in 'string', line 32, column 2 to line 38, column 3)",
                                                      " (in 'string', line 39, column 2 to column 31)",
                                                      " (in 'string', line 41, column 4 to column 23)",
                                                      " (in 'string', line 42, column 11 to column 12)",
                                                      " (in 'string', line 42, column 4 to column 28)",
                                                      " (in 'string', line 43, column 4 to column 81)",
                                                      " (in 'string', line 40, column 18 to line 44, column 3)",
                                                      " (in 'string', line 40, column 2 to line 44, column 3)",
                                                      " (in 'string', line 45, column 2 to column 15)",
                                                      " (in 'string', line 46, column 2 to column 26)",
                                                      " (in 'string', line 48, column 11 to column 12)",
                                                      " (in 'string', line 48, column 4 to column 28)",
                                                      " (in 'string', line 49, column 11 to column 12)",
                                                      " (in 'string', line 49, column 4 to column 27)",
                                                      " (in 'string', line 50, column 4 to column 28)",
                                                      " (in 'string', line 47, column 17 to line 51, column 3)",
                                                      " (in 'string', line 47, column 2 to line 51, column 3)",
                                                      " (in 'string', line 52, column 2 to column 21)",
                                                      " (in 'string', line 22, column 93 to line 53, column 3)"};
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__>
stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, T3__,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>>>
gaussian_filter_rw_lpdf(const T0__& y_arg__, const T1__& a1_arg__,
                        const T2__& P1_arg__, const T3__& Ht,
                        const T4__& Rt_arg__, const T5__& xreg_arg__,
                        std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          T3__,
          stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>>>;
  const auto& y = to_ref(y_arg__);
  const auto& a1 = to_ref(a1_arg__);
  const auto& P1 = to_ref(P1_arg__);
  const auto& Rt = to_ref(Rt_arg__);
  const auto& xreg = to_ref(xreg_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 77;
    n = rows(y);
    int m;
    m = std::numeric_limits<int>::min();
    
    current_statement__ = 78;
    m = rows(a1);
    local_scalar_t__ loglik;
    loglik = DUMMY_VAR__;
    
    current_statement__ = 79;
    loglik = 0.0;
    current_statement__ = 80;
    validate_non_negative_index("x", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> x;
    x = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(x, DUMMY_VAR__);
    
    current_statement__ = 81;
    assign(x, nil_index_list(), a1, "assigning variable x");
    current_statement__ = 82;
    validate_non_negative_index("P", "m", m);
    current_statement__ = 83;
    validate_non_negative_index("P", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, -1> P;
    P = Eigen::Matrix<local_scalar_t__, -1, -1>(m, m);
    stan::math::fill(P, DUMMY_VAR__);
    
    current_statement__ = 84;
    assign(P, nil_index_list(), diag_matrix(P1), "assigning variable P");
    current_statement__ = 93;
    for (int t = 1; t <= n; ++t) {
      local_scalar_t__ F;
      F = DUMMY_VAR__;
      
      current_statement__ = 85;
      F = (quad_form(P,
             rvalue(xreg,
               cons_list(index_omni(),
                 cons_list(index_uni(t), nil_index_list())), "xreg")) + Ht);
      local_scalar_t__ v;
      v = DUMMY_VAR__;
      
      current_statement__ = 86;
      v = (y[(t - 1)] -
            dot_product(
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg"), x));
      current_statement__ = 87;
      validate_non_negative_index("K", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> K;
      K = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(K, DUMMY_VAR__);
      
      current_statement__ = 88;
      assign(K, nil_index_list(),
        divide(
          multiply(P,
            rvalue(xreg,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())), "xreg")), F),
        "assigning variable K");
      current_statement__ = 89;
      assign(x, nil_index_list(),
        add(stan::model::deep_copy(x), multiply(K, v)),
        "assigning variable x");
      current_statement__ = 90;
      assign(P, nil_index_list(),
        add(stan::model::deep_copy(P),
          add(multiply(multiply(minus(K), transpose(K)), F), Rt)),
        "assigning variable P");
      current_statement__ = 91;
      loglik = (loglik - (0.5 * (stan::math::log(F) + ((v * v) / F))));}
    current_statement__ = 94;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct gaussian_filter_rw_lpdf_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__>
stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, T3__,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>>>
operator()(const T0__& y, const T1__& a1, const T2__& P1, const T3__& Ht,
           const T4__& Rt, const T5__& xreg, std::ostream* pstream__)  const 
{
return gaussian_filter_rw_lpdf<propto__>(y, a1, P1, Ht, Rt, xreg, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T5__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, T3__,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>>>, -1, -1>
gaussian_smoother_rw(const T0__& y_arg__, const T1__& a1_arg__,
                     const T2__& P1_arg__, const T3__& Ht,
                     const T4__& Rt_arg__, const T5__& xreg_arg__,
                     std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          T3__,
          stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>>>;
  const auto& y = to_ref(y_arg__);
  const auto& a1 = to_ref(a1_arg__);
  const auto& P1 = to_ref(P1_arg__);
  const auto& Rt = to_ref(Rt_arg__);
  const auto& xreg = to_ref(xreg_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 96;
    n = rows(y);
    int m;
    m = std::numeric_limits<int>::min();
    
    current_statement__ = 97;
    m = rows(a1);
    current_statement__ = 98;
    validate_non_negative_index("x", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> x;
    x = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(x, DUMMY_VAR__);
    
    current_statement__ = 99;
    assign(x, nil_index_list(), a1, "assigning variable x");
    current_statement__ = 100;
    validate_non_negative_index("P", "m", m);
    current_statement__ = 101;
    validate_non_negative_index("P", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, -1> P;
    P = Eigen::Matrix<local_scalar_t__, -1, -1>(m, m);
    stan::math::fill(P, DUMMY_VAR__);
    
    current_statement__ = 102;
    assign(P, nil_index_list(), diag_matrix(P1), "assigning variable P");
    current_statement__ = 103;
    validate_non_negative_index("v", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> v;
    v = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(v, DUMMY_VAR__);
    
    current_statement__ = 105;
    validate_non_negative_index("F", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> F;
    F = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(F, DUMMY_VAR__);
    
    current_statement__ = 107;
    validate_non_negative_index("K", "m", m);
    current_statement__ = 108;
    validate_non_negative_index("K", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, -1> K;
    K = Eigen::Matrix<local_scalar_t__, -1, -1>(m, n);
    stan::math::fill(K, DUMMY_VAR__);
    
    current_statement__ = 110;
    validate_non_negative_index("r", "m", m);
    current_statement__ = 111;
    validate_non_negative_index("r", "n + 1", (n + 1));
    Eigen::Matrix<local_scalar_t__, -1, -1> r;
    r = Eigen::Matrix<local_scalar_t__, -1, -1>(m, (n + 1));
    stan::math::fill(r, DUMMY_VAR__);
    
    current_statement__ = 113;
    validate_non_negative_index("tmpr", "m", m);
    Eigen::Matrix<local_scalar_t__, -1, 1> tmpr;
    tmpr = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
    stan::math::fill(tmpr, DUMMY_VAR__);
    
    current_statement__ = 121;
    for (int t = 1; t <= n; ++t) {
      current_statement__ = 115;
      assign(F, cons_list(index_uni(t), nil_index_list()),
        (quad_form(P,
           rvalue(xreg,
             cons_list(index_omni(),
               cons_list(index_uni(t), nil_index_list())), "xreg")) + Ht),
        "assigning variable F");
      current_statement__ = 116;
      assign(v, cons_list(index_uni(t), nil_index_list()),
        (y[(t - 1)] -
          dot_product(
            rvalue(xreg,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())), "xreg"), x)),
        "assigning variable v");
      current_statement__ = 117;
      assign(K,
        cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
        divide(
          multiply(P,
            rvalue(xreg,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())), "xreg")),
          F[(t - 1)]), "assigning variable K");
      current_statement__ = 118;
      assign(x, nil_index_list(),
        add(stan::model::deep_copy(x),
          multiply(
            rvalue(K,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())), "K"), v[(t - 1)])),
        "assigning variable x");
      current_statement__ = 119;
      assign(P, nil_index_list(),
        add(stan::model::deep_copy(P),
          add(
            multiply(
              multiply(
                minus(
                  rvalue(K,
                    cons_list(index_omni(),
                      cons_list(index_uni(t), nil_index_list())), "K")),
                transpose(
                  rvalue(K,
                    cons_list(index_omni(),
                      cons_list(index_uni(t), nil_index_list())), "K"))),
              F[(t - 1)]), Rt)), "assigning variable P");}
    current_statement__ = 122;
    assign(r,
      cons_list(index_omni(),
        cons_list(index_uni((n + 1)), nil_index_list())), rep_vector(0.0, m),
      "assigning variable r");
    current_statement__ = 128;
    for (int tt = 1; tt <= n; ++tt) {
      int t;
      t = std::numeric_limits<int>::min();
      
      current_statement__ = 123;
      t = ((n + 1) - tt);
      current_statement__ = 124;
      validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 125;
      assign(tmp, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(),
            cons_list(index_uni((t + 1)), nil_index_list())), "r"),
        "assigning variable tmp");
      current_statement__ = 126;
      assign(r,
        cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
        subtract(
          add(
            divide(
              multiply(
                rvalue(xreg,
                  cons_list(index_omni(),
                    cons_list(index_uni(t), nil_index_list())), "xreg"),
                v[(t - 1)]), F[(t - 1)]), tmp),
          multiply(
            rvalue(xreg,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())), "xreg"),
            dot_product(
              rvalue(K,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "K"), tmp))),
        "assigning variable r");}
    current_statement__ = 129;
    assign(tmpr, nil_index_list(),
      rvalue(r,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        "r"), "assigning variable tmpr");
    current_statement__ = 130;
    assign(r,
      cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
      add(a1, elt_multiply(P1, tmpr)), "assigning variable r");
    current_statement__ = 137;
    for (int t = 2; t <= n; ++t) {
      current_statement__ = 131;
      validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp;
      tmp = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp, DUMMY_VAR__);
      
      current_statement__ = 132;
      assign(tmp, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(),
            cons_list(index_uni((t - 1)), nil_index_list())), "r"),
        "assigning variable tmp");
      current_statement__ = 133;
      validate_non_negative_index("tmp2", "m", m);
      Eigen::Matrix<local_scalar_t__, -1, 1> tmp2;
      tmp2 = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(tmp2, DUMMY_VAR__);
      
      current_statement__ = 134;
      assign(tmp2, nil_index_list(),
        rvalue(r,
          cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
          "r"), "assigning variable tmp2");
      current_statement__ = 135;
      assign(r,
        cons_list(index_omni(), cons_list(index_uni(t), nil_index_list())),
        add(tmp, multiply(Rt, tmp2)), "assigning variable r");}
    current_statement__ = 138;
    return rvalue(r,
             cons_list(index_min_max(1, m),
               cons_list(index_min_max(1, n), nil_index_list())), "r");
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct gaussian_smoother_rw_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T5__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, T3__,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>>>, -1, -1>
operator()(const T0__& y, const T1__& a1, const T2__& P1, const T3__& Ht,
           const T4__& Rt, const T5__& xreg, std::ostream* pstream__)  const 
{
return gaussian_smoother_rw(y, a1, P1, Ht, Rt, xreg, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_rw1_model final : public model_base_crtp<model_rw1_model> {
 private:
  int k;
  int n;
  Eigen::Matrix<double, -1, -1> xreg;
  Eigen::Matrix<double, -1, 1> y;
  Eigen::Matrix<double, -1, 1> beta_mean;
  Eigen::Matrix<double, -1, 1> beta_sd;
  Eigen::Matrix<double, -1, 1> sigma_mean;
  Eigen::Matrix<double, -1, 1> sigma_sd;
  int n_new;
  Eigen::Matrix<double, -1, -1> xreg_new;
  Eigen::Matrix<double, -1, 1> sigma_b_mean;
  Eigen::Matrix<double, -1, 1> sigma_b_sd;
  double sigma_y_mean;
  double sigma_y_sd;
 
 public:
  ~model_rw1_model() { }
  
  inline std::string model_name() const final { return "model_rw1_model"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1", "stancflags = "};
  }
  
  
  model_rw1_model(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_rw1_model_namespace::model_rw1_model";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 43;
      context__.validate_dims("data initialization","k","int",
          context__.to_vec());
      k = std::numeric_limits<int>::min();
      
      current_statement__ = 43;
      k = context__.vals_i("k")[(1 - 1)];
      current_statement__ = 43;
      current_statement__ = 43;
      check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 44;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 44;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 44;
      current_statement__ = 44;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 45;
      validate_non_negative_index("xreg", "k", k);
      current_statement__ = 46;
      validate_non_negative_index("xreg", "n", n);
      current_statement__ = 47;
      context__.validate_dims("data initialization","xreg","double",
          context__.to_vec(k, n));
      xreg = Eigen::Matrix<double, -1, -1>(k, n);
      stan::math::fill(xreg, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_flat__;
        current_statement__ = 47;
        assign(xreg_flat__, nil_index_list(), context__.vals_r("xreg"),
          "assigning variable xreg_flat__");
        current_statement__ = 47;
        pos__ = 1;
        current_statement__ = 47;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 47;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 47;
            assign(xreg,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_flat__[(pos__ - 1)], "assigning variable xreg");
            current_statement__ = 47;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 48;
      validate_non_negative_index("y", "n", n);
      current_statement__ = 49;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(n));
      y = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 49;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 49;
        pos__ = 1;
        current_statement__ = 49;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 49;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 49;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 50;
      validate_non_negative_index("beta_mean", "k", k);
      current_statement__ = 51;
      context__.validate_dims("data initialization","beta_mean","double",
          context__.to_vec(k));
      beta_mean = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(beta_mean, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_mean_flat__;
        current_statement__ = 51;
        assign(beta_mean_flat__, nil_index_list(),
          context__.vals_r("beta_mean"),
          "assigning variable beta_mean_flat__");
        current_statement__ = 51;
        pos__ = 1;
        current_statement__ = 51;
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          current_statement__ = 51;
          assign(beta_mean, cons_list(index_uni(sym1__), nil_index_list()),
            beta_mean_flat__[(pos__ - 1)], "assigning variable beta_mean");
          current_statement__ = 51;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 52;
      validate_non_negative_index("beta_sd", "k", k);
      current_statement__ = 53;
      context__.validate_dims("data initialization","beta_sd","double",
          context__.to_vec(k));
      beta_sd = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(beta_sd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_sd_flat__;
        current_statement__ = 53;
        assign(beta_sd_flat__, nil_index_list(), context__.vals_r("beta_sd"),
          "assigning variable beta_sd_flat__");
        current_statement__ = 53;
        pos__ = 1;
        current_statement__ = 53;
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          current_statement__ = 53;
          assign(beta_sd, cons_list(index_uni(sym1__), nil_index_list()),
            beta_sd_flat__[(pos__ - 1)], "assigning variable beta_sd");
          current_statement__ = 53;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 54;
      validate_non_negative_index("sigma_mean", "k + 1", (k + 1));
      current_statement__ = 55;
      context__.validate_dims("data initialization","sigma_mean","double",
          context__.to_vec((k + 1)));
      sigma_mean = Eigen::Matrix<double, -1, 1>((k + 1));
      stan::math::fill(sigma_mean, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_mean_flat__;
        current_statement__ = 55;
        assign(sigma_mean_flat__, nil_index_list(),
          context__.vals_r("sigma_mean"),
          "assigning variable sigma_mean_flat__");
        current_statement__ = 55;
        pos__ = 1;
        current_statement__ = 55;
        for (int sym1__ = 1; sym1__ <= (k + 1); ++sym1__) {
          current_statement__ = 55;
          assign(sigma_mean, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_mean_flat__[(pos__ - 1)], "assigning variable sigma_mean");
          current_statement__ = 55;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 56;
      validate_non_negative_index("sigma_sd", "k + 1", (k + 1));
      current_statement__ = 57;
      context__.validate_dims("data initialization","sigma_sd","double",
          context__.to_vec((k + 1)));
      sigma_sd = Eigen::Matrix<double, -1, 1>((k + 1));
      stan::math::fill(sigma_sd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_sd_flat__;
        current_statement__ = 57;
        assign(sigma_sd_flat__, nil_index_list(),
          context__.vals_r("sigma_sd"), "assigning variable sigma_sd_flat__");
        current_statement__ = 57;
        pos__ = 1;
        current_statement__ = 57;
        for (int sym1__ = 1; sym1__ <= (k + 1); ++sym1__) {
          current_statement__ = 57;
          assign(sigma_sd, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_sd_flat__[(pos__ - 1)], "assigning variable sigma_sd");
          current_statement__ = 57;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 58;
      context__.validate_dims("data initialization","n_new","int",
          context__.to_vec());
      n_new = std::numeric_limits<int>::min();
      
      current_statement__ = 58;
      n_new = context__.vals_i("n_new")[(1 - 1)];
      current_statement__ = 58;
      current_statement__ = 58;
      check_greater_or_equal(function__, "n_new", n_new, 0);
      current_statement__ = 59;
      validate_non_negative_index("xreg_new", "k", k);
      current_statement__ = 60;
      validate_non_negative_index("xreg_new", "n_new", n_new);
      current_statement__ = 61;
      context__.validate_dims("data initialization","xreg_new","double",
          context__.to_vec(k, n_new));
      xreg_new = Eigen::Matrix<double, -1, -1>(k, n_new);
      stan::math::fill(xreg_new, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_new_flat__;
        current_statement__ = 61;
        assign(xreg_new_flat__, nil_index_list(),
          context__.vals_r("xreg_new"), "assigning variable xreg_new_flat__");
        current_statement__ = 61;
        pos__ = 1;
        current_statement__ = 61;
        for (int sym1__ = 1; sym1__ <= n_new; ++sym1__) {
          current_statement__ = 61;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 61;
            assign(xreg_new,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_new_flat__[(pos__ - 1)], "assigning variable xreg_new");
            current_statement__ = 61;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 62;
      validate_non_negative_index("sigma_b_mean", "k", k);
      current_statement__ = 63;
      sigma_b_mean = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(sigma_b_mean, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 63;
      assign(sigma_b_mean, nil_index_list(),
        rvalue(sigma_mean, cons_list(index_min(2), nil_index_list()),
          "sigma_mean"), "assigning variable sigma_b_mean");
      current_statement__ = 64;
      validate_non_negative_index("sigma_b_sd", "k", k);
      current_statement__ = 65;
      sigma_b_sd = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(sigma_b_sd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 65;
      assign(sigma_b_sd, nil_index_list(),
        rvalue(sigma_sd, cons_list(index_min(2), nil_index_list()),
          "sigma_sd"), "assigning variable sigma_b_sd");
      current_statement__ = 66;
      sigma_y_mean = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 66;
      sigma_y_mean = sigma_mean[(1 - 1)];
      current_statement__ = 67;
      sigma_y_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 67;
      sigma_y_sd = sigma_sd[(1 - 1)];
      current_statement__ = 68;
      validate_non_negative_index("sigma_b", "k", k);
      current_statement__ = 69;
      validate_non_negative_index("R_vector", "k", k);
      current_statement__ = 70;
      validate_non_negative_index("P1_vector", "k", k);
      current_statement__ = 71;
      validate_non_negative_index("y_rep", "n", n);
      current_statement__ = 72;
      validate_non_negative_index("beta", "k", k);
      current_statement__ = 73;
      validate_non_negative_index("beta", "n", n);
      current_statement__ = 74;
      validate_non_negative_index("y_new", "n_new", n_new);
      current_statement__ = 75;
      validate_non_negative_index("beta_new", "k", k);
      current_statement__ = 76;
      validate_non_negative_index("beta_new", "n_new", n_new);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += k;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_rw1_model_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> sigma_b;
      sigma_b = std::vector<local_scalar_t__>(k, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_b");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_b[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_b");
        } else {
          current_statement__ = 1;
          assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_b[(sym1__ - 1)], 0),
            "assigning variable sigma_b");
        }}
      local_scalar_t__ sigma_y;
      sigma_y = DUMMY_VAR__;
      
      current_statement__ = 2;
      sigma_y = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        sigma_y = stan::math::lb_constrain(sigma_y, 0, lp__);
      } else {
        current_statement__ = 2;
        sigma_y = stan::math::lb_constrain(sigma_y, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> R_vector;
      R_vector = Eigen::Matrix<local_scalar_t__, -1, 1>(k);
      stan::math::fill(R_vector, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> P1_vector;
      P1_vector = Eigen::Matrix<local_scalar_t__, -1, 1>(k);
      stan::math::fill(P1_vector, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int i = 1; i <= k; ++i) {
        current_statement__ = 5;
        assign(R_vector, cons_list(index_uni(i), nil_index_list()),
          pow(sigma_b[(i - 1)], 2), "assigning variable R_vector");
        current_statement__ = 6;
        assign(P1_vector, cons_list(index_uni(i), nil_index_list()),
          pow(beta_sd[(i - 1)], 2), "assigning variable P1_vector");}
      {
        current_statement__ = 40;
        lp_accum__.add(
          normal_lpdf<propto__>(sigma_b, sigma_b_mean, sigma_b_sd));
        current_statement__ = 41;
        lp_accum__.add(
          normal_lpdf<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
        current_statement__ = 42;
        lp_accum__.add(
          gaussian_filter_rw_lpdf<propto__>(y, beta_mean, P1_vector,
            pow(sigma_y, 2), diag_matrix(R_vector), xreg, pstream__));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_rw1_model_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> sigma_b;
      sigma_b = std::vector<double>(k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_b");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        assign(sigma_b, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_b[(sym1__ - 1)], 0),
          "assigning variable sigma_b");}
      double sigma_y;
      sigma_y = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_y = in__.scalar();
      current_statement__ = 2;
      sigma_y = stan::math::lb_constrain(sigma_y, 0);
      Eigen::Matrix<double, -1, 1> R_vector;
      R_vector = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(R_vector, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> P1_vector;
      P1_vector = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(P1_vector, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        vars__.emplace_back(sigma_b[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_y);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 8;
      for (int i = 1; i <= k; ++i) {
        current_statement__ = 5;
        assign(R_vector, cons_list(index_uni(i), nil_index_list()),
          pow(sigma_b[(i - 1)], 2), "assigning variable R_vector");
        current_statement__ = 6;
        assign(P1_vector, cons_list(index_uni(i), nil_index_list()),
          pow(beta_sd[(i - 1)], 2), "assigning variable P1_vector");}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          vars__.emplace_back(R_vector[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          vars__.emplace_back(P1_vector[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> y_rep;
      y_rep = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y_rep, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> beta;
      beta = Eigen::Matrix<double, -1, -1>(k, n);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> y_new;
      y_new = Eigen::Matrix<double, -1, 1>(n_new);
      stan::math::fill(y_new, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> beta_new;
      beta_new = Eigen::Matrix<double, -1, -1>(k, n_new);
      stan::math::fill(beta_new, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 15;
      for (int i = 1; i <= k; ++i) {
        current_statement__ = 13;
        assign(beta,
          cons_list(index_uni(i), cons_list(index_uni(1), nil_index_list())),
          normal_rng(beta_mean[(i - 1)], beta_sd[(i - 1)], base_rng__),
          "assigning variable beta");}
      current_statement__ = 20;
      for (int t = 1; t <= (n - 1); ++t) {
        current_statement__ = 18;
        for (int i = 1; i <= k; ++i) {
          current_statement__ = 16;
          assign(beta,
            cons_list(index_uni(i),
              cons_list(index_uni((t + 1)), nil_index_list())),
            normal_rng(
              rvalue(beta,
                cons_list(index_uni(i),
                  cons_list(index_uni(t), nil_index_list())), "beta"),
              sigma_b[(i - 1)], base_rng__), "assigning variable beta");}}
      current_statement__ = 23;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 21;
        assign(y_rep, cons_list(index_uni(t), nil_index_list()),
          normal_rng(
            dot_product(
              rvalue(xreg,
                cons_list(index_omni(),
                  cons_list(index_uni(t), nil_index_list())), "xreg"),
              rvalue(beta,
                cons_list(index_min_max(1, k),
                  cons_list(index_uni(t), nil_index_list())), "beta")),
            sigma_y, base_rng__), "assigning variable y_rep");}
      current_statement__ = 24;
      assign(beta, nil_index_list(),
        add(stan::model::deep_copy(beta),
          gaussian_smoother_rw(subtract(y, y_rep), beta_mean, P1_vector,
            pow(sigma_y, 2), diag_matrix(R_vector), xreg, pstream__)),
        "assigning variable beta");
      current_statement__ = 27;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 25;
        assign(y_rep, cons_list(index_uni(t), nil_index_list()),
          (dot_product(
             rvalue(xreg,
               cons_list(index_omni(),
                 cons_list(index_uni(t), nil_index_list())), "xreg"),
             rvalue(beta,
               cons_list(index_min_max(1, k),
                 cons_list(index_uni(t), nil_index_list())), "beta")) +
            normal_rng(0, sigma_y, base_rng__)), "assigning variable y_rep");
      }
      current_statement__ = 39;
      if (logical_gt(n_new, 0)) {
        current_statement__ = 30;
        for (int i = 1; i <= k; ++i) {
          current_statement__ = 28;
          assign(beta_new,
            cons_list(index_uni(i),
              cons_list(index_uni(1), nil_index_list())),
            normal_rng(
              rvalue(beta,
                cons_list(index_uni(i),
                  cons_list(index_uni(n), nil_index_list())), "beta"),
              sigma_b[(i - 1)], base_rng__), "assigning variable beta_new");}
        current_statement__ = 36;
        for (int t = 1; t <= (n_new - 1); ++t) {
          current_statement__ = 31;
          assign(y_new, cons_list(index_uni(t), nil_index_list()),
            (dot_product(
               rvalue(xreg_new,
                 cons_list(index_omni(),
                   cons_list(index_uni(t), nil_index_list())), "xreg_new"),
               rvalue(beta_new,
                 cons_list(index_omni(),
                   cons_list(index_uni(t), nil_index_list())), "beta_new")) +
              normal_rng(0, sigma_y, base_rng__)), "assigning variable y_new");
          current_statement__ = 34;
          for (int i = 1; i <= k; ++i) {
            current_statement__ = 32;
            assign(beta_new,
              cons_list(index_uni(i),
                cons_list(index_uni((t + 1)), nil_index_list())),
              normal_rng(
                rvalue(beta_new,
                  cons_list(index_uni(i),
                    cons_list(index_uni(t), nil_index_list())), "beta_new"),
                sigma_b[(i - 1)], base_rng__), "assigning variable beta_new");
          }}
        current_statement__ = 37;
        assign(y_new, cons_list(index_uni(n_new), nil_index_list()),
          (dot_product(
             rvalue(xreg_new,
               cons_list(index_omni(),
                 cons_list(index_uni(n_new), nil_index_list())), "xreg_new"),
             rvalue(beta_new,
               cons_list(index_omni(),
                 cons_list(index_uni(n_new), nil_index_list())), "beta_new"))
            + normal_rng(0, sigma_y, base_rng__)), "assigning variable y_new");
      } 
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        vars__.emplace_back(y_rep[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta"));}}
      for (int sym1__ = 1; sym1__ <= n_new; ++sym1__) {
        vars__.emplace_back(y_new[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_new; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_new,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_new"));
        }}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> sigma_b;
      sigma_b = std::vector<double>(k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(sigma_b, nil_index_list(), context__.vals_r("sigma_b"),
        "assigning variable sigma_b");
      std::vector<double> sigma_b_free__;
      sigma_b_free__ = std::vector<double>(k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        current_statement__ = 1;
        assign(sigma_b_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_b[(sym1__ - 1)], 0),
          "assigning variable sigma_b_free__");}
      double sigma_y;
      sigma_y = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_y = context__.vals_r("sigma_y")[(1 - 1)];
      double sigma_y_free__;
      sigma_y_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_y_free__ = stan::math::lb_free(sigma_y, 0);
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        vars__.emplace_back(sigma_b_free__[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_y_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("sigma_b");
    names__.emplace_back("sigma_y");
    names__.emplace_back("R_vector");
    names__.emplace_back("P1_vector");
    names__.emplace_back("y_rep");
    names__.emplace_back("beta");
    names__.emplace_back("y_new");
    names__.emplace_back("beta_new");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k),
                                             static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_new)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k),
                                             static_cast<size_t>(n_new)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_b" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_y");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "R_vector" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "P1_vector" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_rep" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_new; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_new" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_new; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta_new" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_b" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_y");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "R_vector" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "P1_vector" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_rep" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_new; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_new" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_new; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta_new" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"sigma_b\",\"type\":{\"name\":\"array\",\"length\":" << k << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"R_vector\",\"type\":{\"name\":\"vector\",\"length\":" << k << "},\"block\":\"transformed_parameters\"},{\"name\":\"P1_vector\",\"type\":{\"name\":\"vector\",\"length\":" << k << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_rep\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << n << "},\"block\":\"generated_quantities\"},{\"name\":\"y_new\",\"type\":{\"name\":\"vector\",\"length\":" << n_new << "},\"block\":\"generated_quantities\"},{\"name\":\"beta_new\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << n_new << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"sigma_b\",\"type\":{\"name\":\"array\",\"length\":" << k << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"R_vector\",\"type\":{\"name\":\"vector\",\"length\":" << k << "},\"block\":\"transformed_parameters\"},{\"name\":\"P1_vector\",\"type\":{\"name\":\"vector\",\"length\":" << k << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_rep\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << n << "},\"block\":\"generated_quantities\"},{\"name\":\"y_new\",\"type\":{\"name\":\"vector\",\"length\":" << n_new << "},\"block\":\"generated_quantities\"},{\"name\":\"beta_new\",\"type\":{\"name\":\"matrix\",\"rows\":" << k << ",\"cols\":" << n_new << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_rw1_model_namespace::model_rw1_model;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_rw1_model_namespace::profiles__;
}
#endif
#endif
