% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate_norm}
\alias{generate_norm}
\title{Generate truncated normal scores}
\usage{
generate_norm(n_candidates, n_voters, min = 0, max = 1, mean = 0.5, sd = 0.25)
}
\arguments{
\item{n_candidates}{The number of candidates to generate scores for.}

\item{n_voters}{The number of voters to generate scores for.}

\item{min}{The minimum value of the truncated normal distribution.}

\item{max}{The maximum value of the truncated normal distribution.}

\item{mean}{The mean of the truncated normal distribution.}

\item{sd}{The standard deviation of the truncated normal distribution.}
}
\value{
A matrix of scores with 'n_candidates' rows and 'n_voters' columns.
}
\description{
This function generates truncated normal scores using the 'rtruncnorm' function from the 'truncnorm' package.
}
\examples{
voting_situation<- generate_norm(n_voters=10, n_candidates=3, min=0, max=10, mean=0.7)
}
