% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.timeline.twitter.R
\name{Collect.timeline.twitter}
\alias{Collect.timeline.twitter}
\title{Collect tweet data from twitter timelines}
\usage{
\method{Collect}{timeline.twitter}(
  credential,
  endpoint,
  users = c(),
  numTweets = 100,
  retryOnRateLimit = TRUE,
  writeToFile = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"twitter"}.}

\item{endpoint}{API endpoint.}

\item{users}{Character vector. Specifies one or more twitter users. Can be user names, user ids or a mixture.}

\item{numTweets}{Numeric vector. Specifies how many tweets to be collected per user. Defaults to single value of
\code{100}.}

\item{retryOnRateLimit}{Logical. When the API rate-limit is reached should the collection wait and resume when it
resets. Default is \code{TRUE}.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information about the data collection. Default is \code{FALSE}.}

\item{...}{
  Arguments passed on to \code{\link[rtweet:get_timeline]{rtweet::get_timeline}}
  \describe{
    \item{\code{since_id}}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{newer} than \code{since_id}.}
    \item{\code{parse}}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}
    \item{\code{check}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
    \item{\code{retryonratelimit}}{If \code{TRUE}, and a rate limit is exhausted, will wait
until it refreshes. Most Twitter rate limits refresh every 15 minutes.
If \code{FALSE}, and the rate limit is exceeded, the function will terminate
early with a warning; you'll still get back all results received up to
that point. The default value, \code{NULL}, consults the option
\code{rtweet.retryonratelimit} so that you can globally set it to \code{TRUE},
if desired.

If you expect a query to take hours or days to perform, you should not
rely soley on \code{retryonratelimit} because it does not handle other common
failure modes like temporarily losing your internet connection.}
  }}
}
\value{
A tibble object with class names \code{"datasource"} and \code{"twitter"}.
}
\description{
This function collects user timeline tweets and structures the data into a dataframe with the class
names \code{"datasource"} and \code{"twitter"}. The Twitter API limits collection to a maximum of 3,200 of the most
recent timeline tweets per user.
}
