% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddUserData.R
\name{AddUserData.actor.twitter}
\alias{AddUserData.actor.twitter}
\title{Supplement twitter actor network by adding user profile attributes to nodes}
\usage{
\method{AddUserData}{actor.twitter}(
  net,
  data,
  lookupUsers = FALSE,
  twitterAuth = NULL,
  retryOnRateLimit = TRUE,
  refresh = FALSE,
  rmMisc = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{net}{A named list of dataframes \code{nodes} and \code{edges} generated by \code{Create}.}

\item{data}{A dataframe generated by \code{Collect}.}

\item{lookupUsers}{Logical. Lookup user profile metadata using the twitter API for any users data missing from the
collect data set. For example fetches profile information for users that became nodes during network creation
because they were mentioned in a tweet but did not author any tweets themselves. Default is \code{FALSE}.}

\item{twitterAuth}{A twitter authentication object from \code{Authenticate}.}

\item{retryOnRateLimit}{Logical. When the API rate-limit is reached should the collection wait and resume when it
resets. Default is \code{TRUE}.}

\item{refresh}{Logical. Lookup and replace all available user metadata. Default is \code{FALSE}.}

\item{rmMisc}{Logical. Remove miscellaneous user data columns such as user profile colors and other visual elements.
Default is \code{TRUE}.}

\item{verbose}{Logical. Output additional information. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of three dataframes containing \code{$nodes}, \code{$edges}. Nodes include columns
for additional user profile data and metrics. Referenced users for which no data was found are returned in
\code{missing_users}.
}
\description{
Network is supplemented with additional downloaded user information applied as 2mode node attributes.
}
\note{
Using the standard twitter API this function is limited to collecting profiles of 90000 users per 15 mins
before hitting the rate limit.
}
\examples{
\dontrun{
# add user info to a twitter actor network
net_actor <- data_collect |>
  Create("actor") |>
  AddUserData(data_collect)
}

}
