% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.actor.reddit.R
\name{Create.actor.reddit}
\alias{Create.actor.reddit}
\title{Create reddit actor network}
\usage{
\method{Create}{actor.reddit}(datasource, type, ...)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"reddit"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"actor"}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a reddit actor network from thread comments on subreddits. Users who have commented on a thread 
are actor nodes and comment replies to each other are represented as directed edges.
}
\examples{
\dontrun{
# create a reddit actor network graph with comment text as edge attributes
actorNetwork <- redditData \%>\% Create("actor")

# network
# actorNetwork$nodes
# actorNetwork$edges
}

}
