% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocalgraphs.R
\name{getTurnTakingProbMatrix}
\alias{getTurnTakingProbMatrix}
\title{getTurnTakingProbMatrix: create a vocaldia from a
    data.frame.}
\usage{
getTurnTakingProbMatrix(df, individual = FALSE, ...)
}
\arguments{
\item{df}{a data frame consisting, minimally, of a column for
vocalisation/pause start times, a column for end times, and a
column identifying the speaker, speaker role or 'Floor' (for
silences).}

\item{individual}{whether to include individual speakers or group
them into a single Vocalisation node}

\item{...}{other parameters to be passed to
\code{\link{getTurnTakingMatrix}}.}
}
\value{
a vocaldia object, consisting of a vocalisation matrix
    (vocmatrix) where cell \eqn{(m,n)} contains the probabilities \eqn{P(n|m)}
    transitions to node \eqn{n} from node \eqn{m}, and a table of prior
    probabilities (stationary distribution) per node.
}
\description{
Convert a data frame into a vocalisation diagram using counts rather than sampling.
}
\details{
Unlike \code{\link{getSampledVocalMatrix}}, this function is based
on transition counts rather than sampled intervals. As a result,
where in this version self transitions will always be set to 0
(since a vocalisation by a speaker is never followed by another
vocalisation by the same speaker) in the sampled version self
transitons will usually dominate the distribution, since the
speaker who is speaking now is very likely to be the one who were
speaking one second ago.
}
\examples{
x <- subset(atddia, id=='Abbott_Maddock_01')
getTurnTakingProbMatrix(x)
getTurnTakingProbMatrix(x, individual=TRUE)
}
\seealso{
(Luz, 2013) and  \code{\link{getTurnTakingMatrix}}.

  S. Luz. Automatic identification of experts and performance
  prediction in the multimodal math data corpus through analysis
  of speech interaction. In \emph{Proceedings of the 15th ACM on
  International Conference on Multimodal Interaction, ICMI'13},
  pages 575--582, New York, NY, USA, 2013. ACM.
}
