% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locmap.R
\name{locread}
\alias{locread}
\alias{locwrite}
\title{Locmap management}
\usage{
locread(file, name = "", desc = "", bs = numeric(), ...)

locwrite(locmap, file, ...)
}
\arguments{
\item{file}{the name of the file which the data are to be read from}

\item{name}{to give the location map}

\item{desc}{brief description for the location map}

\item{bs}{locations that should be excluded from statistical analysis because
of their proximity to the blind spot}

\item{...}{arguments to be passed to or from methods}

\item{locmap}{location map from which to get coordinates to export as csv file}
}
\value{
\code{locread} a list with information about a location map

\code{locwrite} No return value
}
\description{
Functions to handle location maps, which are lists with x and y
coordinates and other importan information about the visual field test
locations. Check section \code{Structure of location maps} below for details
}
\details{
\itemize{
    \item\code{locread} reads a csv file with location map data
    \item\code{locwrite} writes a csv file with location map data
}
}
\section{Structure of location maps}{

Each element in the list \code{locmaps} is a location map that
contains the following fields
\itemize{
  \item\code{name} descriptive name
  \item\code{desc} brief description
  \item\code{coord} coordinates of the visual field locations
  \item\code{bs} if not empty, the locations that ought to be removed
    for statistical analysis due to their proximity to the blind spot
}
}

\examples{
# write and read location map
tf <- tempfile("locmap")
locwrite(getlocmap(), file = tf) # save current locmap in a temp file
print(locread(tf, name = "name", desc = "desc", bs = c(1, 2))) # read the temp file
}
