% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_summary.R
\name{get_summary}
\alias{get_summary}
\alias{get_summary.survfit}
\title{Summarize the descriptive statistics across strata from a survival object using S3 method}
\usage{
get_summary(x, ...)

\method{get_summary}{survfit}(
  x,
  statlist = c("strata", "records", "events", "median", "LCL", "UCL", "CI"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{survfit}}

\item{...}{other arguments passed on to the method}

\item{statlist}{Character vector containing the desired information to be displayed. The order of the arguments determines the order in which
they are displayed in the final result. Default is the strata ("strata"), number of subjects ("records"), number of events ("events"),
the median survival time ("median"), the Confidence Interval ("CI"), the Lower Confidence Limit ("UCL") and the Upper Confidence Limit ("UCL").

@examples

survfit_object <- survival::survfit(data = adtte, Surv(AVAL, 1-CNSR) ~ TRTP)
get_summary(survfit_object)}
}
\value{
A data frame with summary measures from a \code{survfit} object
}
\description{
S3 method for extracting descriptive statistics across strata.
No default method is available at the moment.
}
