% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visIgraph.R
\name{visNetwork-igraph}
\alias{visNetwork-igraph}
\alias{visIgraph}
\alias{toVisNetworkData}
\title{Render a visNetwork object from an igraph object}
\usage{
visIgraph(igraph, idToLabel = TRUE, layout = "layout_nicely",
  physics = FALSE, smooth = FALSE, type = "square",
  randomSeed = NULL, layoutMatrix = NULL, ...)

toVisNetworkData(igraph, idToLabel = TRUE)
}
\arguments{
\item{igraph}{: a igraph object}

\item{idToLabel}{: Boolean. Default to TRUE. Use id of nodes as label ?}

\item{layout}{: Character Name of igraph layout function to use. Default to "layout_nicely"}

\item{physics}{: Boolean. Default to FALSE. Enabled physics on nodes ?}

\item{smooth}{: Boolean. Default to FALSE. Use smooth edges ?}

\item{type}{: Character Type of scale from igrah to vis.js. "square" (defaut) render in a square limit by height. "full" use width and height to scale in a rectangle.}

\item{randomSeed}{: Number. The nodes are randomly positioned initially. This means that the settled result is different every time. If you provide a random seed manually, the layout will be the same every time.}

\item{layoutMatrix}{: in case of layout = 'layout.norm'. the 'layout' argument (A matrix with two or three columns, the layout to normalize)}

\item{...}{: Adding arguments to layout function}
}
\description{
Render a visNetwork object from an igraph object. \link{toVisNetworkData} transfrom igraph data to visNetwork data.
We actually try to keep color, size and label from igraph to visNetwork.
\link{visIgraph} plot directly an igraph object in visNetwork, using \link{toVisNetworkData} to extract data, and
\link{visIgraphLayout} to compute layout and coordinates before rendering.
}
\examples{

\dontrun{
require(igraph)
igraph_network <- graph.famous("Walther")

# get data and plot :
data <- toVisNetworkData(igraph_network)
visNetwork(nodes = data$nodes, edges = data$edges)

# or plot directly
visIgraph(igraph_network)

# change layout
visIgraph(igraph_network, layout = "layout_in_circle")

# options
visIgraph(igraph_network, layout = "layout_in_circle", 
 physics = FALSE, smooth = TRUE)
 
# passing some info  
g <- graph.star(8)
V(g)$color <- c("green", "grey")
V(g)$size <- 1:8 *5
V(g)$label <- LETTERS[1:8]
V(g)$label.cex = seq(1, 2,length.out = 8)
V(g)$label.color = "red"
visIgraph(g, layout = "layout.circle", idToLabel = FALSE)  

g <- graph.full(5)
E(g)$weight <- runif(ecount(g))
E(g)$width <- 1
E(g)$color <- "red"
E(g)[ weight < 0.5 ]$width <- 4
E(g)[ weight < 0.5 ]$color <- "green"
E(g)$label <- LETTERS[1:10]
E(g)$label.cex = seq(1, 2,length.out = 10)
E(g)$label.color = "red"
visIgraph(g)

# color vertices of the largest component
largest_comp <- function(graph) {
 cl <- components(graph)
 V(graph)[which.max(cl$csize) == cl$membership]
}
g <- sample_(gnp(100, 2/100),
           with_vertex_(size = 3, label = ""),
            with_graph_(layout = layout_with_fr)
)
giant_v <- largest_comp(g)
V(g)$color <- "blue"
V(g)[giant_v]$color <- "orange"
plot(g)
visIgraph(g)
}
}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}
