% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker.R
\name{vetiver_deploy_sagemaker}
\alias{vetiver_deploy_sagemaker}
\title{Deploy a vetiver model API to Amazon SageMaker}
\usage{
vetiver_deploy_sagemaker(
  board,
  name,
  instance_type,
  ...,
  predict_args = list(),
  docker_args = list(),
  build_args = list(),
  endpoint_args = list(),
  repo_name = glue("vetiver-sagemaker-{name}")
)
}
\arguments{
\item{board}{An AWS S3 board created with \code{\link[pins:board_s3]{pins::board_s3()}}. This board
must be in the correct region for your SageMaker instance.}

\item{name}{Pin name.}

\item{instance_type}{Type of EC2 instance to use; see
\href{https://aws.amazon.com/sagemaker/pricing/}{Amazon SageMaker pricing}.}

\item{...}{Not currently used.}

\item{predict_args}{A list of optional arguments passed to \code{\link[=vetiver_api]{vetiver_api()}}
such as the prediction \code{type}.}

\item{docker_args}{A list of optional arguments passed to
\code{\link[=vetiver_write_docker]{vetiver_write_docker()}} such as the \code{lockfile} name or whether to use
\code{rspm}. Do not pass \code{additional_pkgs} here, as this function uses
\code{additional_pkgs = required_pkgs(board)}.}

\item{build_args}{A list of optional arguments passed to
\code{\link[=vetiver_sm_build]{vetiver_sm_build()}} such as the model \code{version} or the \code{compute_type}.}

\item{endpoint_args}{A list of optional arguments passed to
\code{\link[=vetiver_sm_endpoint]{vetiver_sm_endpoint()}} such as \code{accelerator_type} or \code{data_capture_config}.}

\item{repo_name}{The name for the AWS ECR repository to store the model.}
}
\value{
The deployed \code{\link[=vetiver_endpoint_sagemaker]{vetiver_endpoint_sagemaker()}}.
}
\description{
Use \code{vetiver_deploy_sagemaker()} to deploy a \code{\link[=vetiver_model]{vetiver_model()}}
that has been versioned and stored via \code{\link[=vetiver_pin_write]{vetiver_pin_write()}} as a Plumber API
on Amazon SageMaker.
}
\details{
This function stores your model deployment image in the same bucket used
by \code{board}.

The function \code{vetiver_deploy_sagemaker()} uses:
\itemize{
\item \code{\link[=vetiver_sm_build]{vetiver_sm_build()}} to build and push a Docker image to ECR,
\item \code{\link[=vetiver_sm_model]{vetiver_sm_model()}} to create a SageMaker model, and
\item \code{\link[=vetiver_sm_endpoint]{vetiver_sm_endpoint()}} to deploy a SageMaker model endpoint.
}

These modular functions are available for more advanced use cases.
}
\examples{
if (FALSE) {
library(pins)
b <- board_s3(bucket = "my-existing-bucket")
cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
vetiver_pin_write(b, v)

endpoint <- vetiver_deploy_sagemaker(
    board = b,
    name = "cars_linear",
    instance_type = "ml.t2.medium",
    predict_args = list(type = "class", debug = TRUE)
)
}

}
\seealso{
\code{\link[=vetiver_sm_build]{vetiver_sm_build()}}, \code{\link[=vetiver_sm_model]{vetiver_sm_model()}}, \code{\link[=vetiver_sm_endpoint]{vetiver_sm_endpoint()}}
}
