% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/installed.versions.R
\name{installed.versions}
\alias{installed.versions}
\title{installed.versions}
\usage{
installed.versions(pkgs, lib)
}
\arguments{
\item{pkgs}{character vector of the names of packages for which to query the
 installed versions}

\item{lib}{character vector of length one giving the library directory
 containing the packages to query. If missing, defaults to the
 first element of \code{\link{.libPaths}()}.}
}
\value{
a named character vector of version numbers corresponding to
\code{pkgs}, with names giving the package names. If a packakge could not be
found in \code{lib}, an NA will be returned.
}
\description{
List the installed versions of packages in a library directory
}
\examples{
# the versions of versions
installed.versions('versions')

# apply to multiple packages
installed.versions(c('stats', 'versions'))

# add a package that doesn't exist or isn't installed
# (returns NA for that one)
installed.versions(c('stats', 'versions', 'notapackage'))
}

