% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_observed.R
\name{proportions_observed}
\alias{proportions_observed}
\title{Calculate the proportions of each level of a variable after applying
\code{summary_observed} to observed values.}
\usage{
proportions_observed(obs_data, strata_vars, digits = 2)
}
\arguments{
\item{obs_data}{A data frame containing the output from \code{summary_observed}.}

\item{strata_vars}{A vector of column names identifying the variables to be
used for stratification.}

\item{digits}{Number of decimal places to round the results to. Default is 2.}
}
\value{
A data frame that contains the proportions after applying
\code{summary_observed}.
}
\description{
Calculate the proportions of each level of a variable after applying
\code{summary_observed} to observed values.
}
\examples{
\donttest{
local_dir <- system.file("extdata", "right", package = "verdata")
replicates_data <- read_replicates(local_dir, "reclutamiento", c(1, 2), version = "v1")
tab_observed <- summary_observed("reclutamiento", replicates_data,
strata_vars = "sexo", conflict_filter = TRUE, forced_dis_filter = FALSE,
edad_minors_filter = TRUE, include_props = TRUE)
prop_data <- proportions_observed(tab_observed, strata_vars = "sexo",
digits = 2)
}
}
