% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdrange.R
\name{stdrange}
\alias{stdrange}
\alias{ustdrange}
\title{Standardize or Unstandarize the Column Range}
\usage{
stdrange(x, mins = apply(x, 2, min), maxs = apply(x, 2, max))

ustdrange(x, mins, maxs)
}
\arguments{
\item{x}{matrix containing the design, or an object coercible to a matrix.}

\item{mins}{vector of original values, one for each column, which should be recoded to the value -1;
or which have alreadty been recoded to -1. This and the next argument are both recycled if not of the correct length.}

\item{maxs}{vector of original values which should be recoded as 1, or which have already been recoded to 1.}
}
\description{
Simple functions for rescaling a data matrix to a coded design and back. \code{stdrange} converts
the design in actual measurements into a coded design, while \code{ustdrange} reverses the process
(if the correct arguments are given).
}
\author{
Pieter C. Schoonees
}
