% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{vec_size}
\alias{vec_size}
\alias{vec_size_common}
\alias{list_sizes}
\alias{vec_is_empty}
\title{Number of observations}
\usage{
vec_size(x)

vec_size_common(
  ...,
  .size = NULL,
  .absent = 0L,
  .arg = "",
  .call = caller_env()
)

list_sizes(x)

vec_is_empty(x)
}
\arguments{
\item{x, ...}{Vector inputs or \code{NULL}.}

\item{.size}{If \code{NULL}, the default, the output size is determined by
recycling the lengths of all elements of \code{...}. Alternatively, you can
supply \code{.size} to force a known size; in this case, \code{x} and \code{...} are
ignored.}

\item{.absent}{The size used when no input is provided, or when all input
is \code{NULL}. If left as \code{NULL} when no input is supplied, an error is thrown.}

\item{.arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{.call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An integer (or double for long vectors).

\code{vec_size_common()} returns \code{.absent} if all inputs are \code{NULL} or
absent, \code{0L} by default.
}
\description{
\code{vec_size(x)} returns the size of a vector. \code{vec_is_empty()}
returns \code{TRUE} if the size is zero, \code{FALSE} otherwise.

The size is distinct from the \code{\link[=length]{length()}} of a vector because it
generalises to the "number of observations" for 2d structures,
i.e. it's the number of rows in matrix or a data frame.  This
definition has the important property that every column of a data
frame (even data frame and matrix columns) have the same size.
\code{vec_size_common(...)} returns the common size of multiple vectors.

\code{list_sizes()} returns an integer vector containing the size of each element
of a list. It is nearly equivalent to, but faster than,
\code{map_int(x, vec_size)}, with the exception that \code{list_sizes()} will
error on non-list inputs, as defined by \code{\link[=vec_is_list]{vec_is_list()}}. \code{list_sizes()} is
to \code{vec_size()} as \code{\link[=lengths]{lengths()}} is to \code{\link[=length]{length()}}.
}
\details{
There is no vctrs helper that retrieves the number of columns: as this
is a property of the \link[=vec_ptype_show]{type}.

\code{vec_size()} is equivalent to \code{NROW()} but has a name that is easier to
pronounce, and throws an error when passed non-vector inputs.
}
\section{Invariants}{

\itemize{
\item \code{vec_size(dataframe)} == \code{vec_size(dataframe[[i]])}
\item \code{vec_size(matrix)} == \code{vec_size(matrix[, i, drop = FALSE])}
\item \code{vec_size(vec_c(x, y))} == \code{vec_size(x)} + \code{vec_size(y)}
}
}

\section{The size of NULL}{


The size of \code{NULL} is hard-coded to \code{0L} in \code{vec_size()}.
\code{vec_size_common()} returns \code{.absent} when all inputs are \code{NULL}
(if only some inputs are \code{NULL}, they are simply ignored).

A default size of 0 makes sense because sizes are most often
queried in order to compute a total size while assembling a
collection of vectors. Since we treat \code{NULL} as an absent input by
principle, we return the identity of sizes under addition to
reflect that an absent input doesn't take up any size.

Note that other defaults might make sense under different
circumstances. For instance, a default size of 1 makes sense for
finding the common size because 1 is the identity of the recycling
rules.
}

\section{Dependencies}{

\itemize{
\item \code{\link[=vec_proxy]{vec_proxy()}}
}
}

\examples{
vec_size(1:100)
vec_size(mtcars)
vec_size(array(dim = c(3, 5, 10)))

vec_size_common(1:10, 1:10)
vec_size_common(1:10, 1)
vec_size_common(integer(), 1)

list_sizes(list("a", 1:5, letters))
}
\seealso{
\code{\link[=vec_slice]{vec_slice()}} for a variation of \code{[} compatible with \code{vec_size()},
and \code{\link[=vec_recycle]{vec_recycle()}} to \link[=vector_recycling_rules]{recycle} vectors to common
length.
}
