% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.odds}
\alias{meta.lm.odds}
\title{Meta-regression analysis for odds ratios}
\usage{
meta.lm.odds(alpha, f1, f2, n1, n2, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{vector of group 1 frequency counts}

\item{f2}{vector of group 2 frequency counts}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item exp(Estimate) - the exponentiated estimate
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a log odds
ratio. The estimates are OLS estimates with robust standard errors
that accommodate residual heteroscedasticity. The exponentiated
slope estimate for a predictor variable describes a multiplicative
change in the odds ratio associated with a 1-unit increase in that
predictor variable, controlling for all other predictor variables
in the model.
}
\examples{
n1 <- c(204, 201, 932, 130, 77)
n2 <- c(106, 103, 415, 132, 83)
f1 <- c(24, 40, 93, 14, 5)
f2 <- c(12, 9, 28, 3, 1)
x1 <- c(4, 4, 5, 3, 26)
x2 <- c(1, 1, 1, 0, 0)
X <- matrix(cbind(x1, x2), 5, 2)
meta.lm.odds(.05, f1, f2, n1, n2, X)

# Should return:
#        Estimate         SE           z     p         LL         UL
# b0  1.541895013 0.69815801  2.20851868 0.027  0.1735305 2.91025958
# b1 -0.004417932 0.04840623 -0.09126784 0.927 -0.0992924 0.09045653
# b2 -1.071122269 0.60582695 -1.76803337 0.077 -2.2585213 0.11627674
#    exp(Estimate)   exp(LL)   exp(UL)
# b0     4.6734381 1.1894969 18.361564
# b1     0.9955918 0.9054779  1.094674
# b2     0.3426238 0.1045049  1.123307


}
\references{
\insertRef{Bonett2015}{vcmeta}
}
