% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_to_popsum.R
\name{gt2popsum}
\alias{gt2popsum}
\alias{Population genetics summaries}
\alias{gt.to.popsum}
\title{Population genetics summaries}
\usage{
gt2popsum(x, deprecated = TRUE)

gt.to.popsum(x)
}
\arguments{
\item{x}{object of class chromR or vcfR}

\item{deprecated}{logical specifying whether to run the function (FALSE) or present deprecation message (TRUE).}
}
\description{
Functions that make population genetics summaries
}
\details{
The function `gt2popsum` was deprecated in vcfR 1.8.0.
This was because it was written entirely in R and did not perform well.
Users should use `gt.to.popsum()` instead because it has similar 
functionality but includes calls to C++ to increase its performance.

This function creates common population genetic summaries from either a chromR or vcfR object.
The default is to return a matrix containing allele counts, He, and Ne.
\strong{Allele_counts} is the a comma delimited string of counts.
The first position is the count of reference alleles, the second positions is the count of the first alternate alleles, the third is the count of second alternate alleles, and so on.
\strong{He} is the gene diversity, or heterozygosity, of the population.
This is \eqn{1 - \sum x^{2}_{i}}, or the probability that two alleles sampled from the population are different, following Nei (1973).
\strong{Ne} is the effective number of alleles in the population.
This is \eqn{1/\sum x^{2}_{i}} or one minus the homozygosity, from Nei (1987) equation 8.17. 

Nei, M., 1973. Analysis of gene diversity in subdivided populations. Proceedings of the National Academy of Sciences, 70(12), pp.3321-3323.

Nei, M., 1987. Molecular evolutionary genetics. Columbia University Press.
}
\examples{
data(vcfR_test)
# Check the genotypes.
extract.gt(vcfR_test)
# Summarize the genotypes.
gt.to.popsum(vcfR_test)

}
