% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_subset.R
\name{vascr_edit_sample}
\alias{vascr_edit_sample}
\title{Rename a sample in a vascr dataset}
\usage{
vascr_edit_sample(data.df, change_list, partial = TRUE, escape = TRUE)
}
\arguments{
\item{data.df}{Vascr dataset to update}

\item{change_list}{List of vectors containing pairs of search and replacement terms to replace}

\item{partial}{TRUE or FALSE, defines if partial matches should be changed}

\item{escape}{TRUE or FALSE, whether to escape special characters passed into the function}
}
\value{
An updated vascr data frame
}
\description{
Renames samples in a vascr dataset, either replacing the whole sample or parts of the string.
}
\examples{
to_rename = growth.df \%>\% vascr_subset(sample = c("0 cells","20,000 cells", "10,000 cells"))

to_rename$Sample \%>\% unique()

renamed = vascr_edit_sample(to_rename, change_list = list(c("0_cells", "Cell Free")))
print(renamed$Sample \%>\% unique())
}
