% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univ.desc.R
\name{univ.desc}
\alias{univ.desc}
\title{Simplified Descriptive Statistics}
\usage{
univ.desc(df, var1, by1)
}
\arguments{
\item{df}{data frame to read in.}

\item{var1}{the dependent/outcome variable, \eqn{Y}. The variable of interest .}

\item{by1}{the main independent/predictor variable, \eqn{X_1}. A grouping variable by which the descriptive statistics for \code{var1} should be parsed.}
}
\value{
This function returns the descriptive statistics for \code{var1} in data frame \code{df}. Can be split to return descriptives for \code{var1} in data frame \code{df}, broken out by \code{var2}.
}
\description{
This function returns univariate/descriptive statistics (univ.desc) on a variable within a given data frame, and uses simplified calls within the function to parse the descriptives by another variable.
}
\examples{
data <- mtcars

univ.desc(data,mpg)
}
