% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{UniqueAtomHashes}
\alias{UniqueAtomHashes}
\title{Create Unique Atom Hashes}
\usage{
UniqueAtomHashes(atoms.oi, cols.oi, separator = "_")
}
\arguments{
\item{atoms.oi}{A data.frame containing the common PDB information in columns}

\item{cols.oi}{A vector of column names to be used in the construction of the
unique atom hashes}

\item{separator}{A single character string to separate the atom specific
identifiers. Acceptable separators include: _ (default), -, +, ., :, |, " "
(space), and "" (no separator).}
}
\value{
a vector of strings containing the unique atom hashes
}
\description{
Constructs unique atom hashes from the provided
}
\details{
Using atom specific identifiers from a PDB-like formatted
data.frame, unique atom hashes are constructed. The identifiers are
separated by a user-defined separator, the default separator is an
underscores ("_"), and the constructed hashes are returned as a vector.

Select a separator to allow easy splitting of the  the unique atom hashes
using the \code{\link[base:strsplit]{base::strsplit()}} function to access the individual components.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  atoms.oi <- thrombin.1hai$atom[1:10, ]
  cols.oi <- c("elety", "resid", "chain", "resno")
  UniqueAtomHashes(atoms.oi, cols.oi, separator = "_")
  # [1] "N_THR_L_1"   "CA_THR_L_1"  "C_THR_L_1"   "O_THR_L_1"   "CB_THR_L_1"
  #     "OG1_THR_L_1" "CG2_THR_L_1" "N_PHE_L_1"   "CA_PHE_L_1"  "C_PHE_L_1"

  UniqueAtomHashes(atoms.oi, cols.oi, separator = "!")
  # The provided separator "!" is not acceptable. The default separator "_" is being used.
  #  [1] "N_THR_L_1"   "CA_THR_L_1"  "C_THR_L_1"   "O_THR_L_1"   "CB_THR_L_1"
  #      "OG1_THR_L_1" "CG2_THR_L_1" "N_PHE_L_1"   "CA_PHE_L_1"  "C_PHE_L_1"
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
