% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_genome.r
\name{bound_intervals}
\alias{bound_intervals}
\title{Select intervals bounded by a genome.}
\usage{
bound_intervals(x, genome, trim = FALSE)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{genome}{\code{\link[=tbl_genome]{tbl_genome()}}}

\item{trim}{adjust coordinates for out-of-bounds intervals}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}}
}
\description{
Used to remove out-of-bounds intervals, or trim interval coordinates using a
\code{genome}.
}
\examples{
x <- trbl_interval(
 ~chrom, ~start, ~end,
 "chr1", -100,   500,
 "chr1", 100,    1e9,
 "chr1", 500,    1000
)

genome <- read_genome(valr_example('hg19.chrom.sizes.gz'))

# out-of-bounds are removed by default ...
bound_intervals(x, genome)

# ... or can be trimmed within the bounds of a genome
bound_intervals(x, genome, trim = TRUE)

}
