% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_fisher.r
\name{bed_fisher}
\alias{bed_fisher}
\title{Fisher's test on number of shared and unique intervals.}
\usage{
bed_fisher(x, y, genome)
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}

\item{genome}{tbl of chrom sizes}
}
\value{
\code{data_frame}
}
\description{
Borrows from the \code{BEDtools} implementation.
}
\details{
Interval statistics can be used in combination with 
  \code{\link[dplyr]{group_by}} and \code{\link[dplyr]{do}} to calculate 
  statistics for subsets of data. See the Interval statistics vignette for
  examples.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 10,     20,
  "chr1", 30,     40,
  "chr1", 51,     52
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 15,     25,
  "chr1", 51,     52
)

genome <- tibble::tribble(
  ~chrom, ~size,
  "chr1", 500
)

bed_fisher(x, y, genome)

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/fisher.html}

Other interval-stats: \code{\link{bed_absdist}},
  \code{\link{bed_jaccard}}, \code{\link{bed_projection}},
  \code{\link{bed_reldist}}
}

