% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R, R/expressionset.R
\docType{methods}
\name{origin}
\alias{origin}
\alias{origin,expressionset-method}
\alias{origin,rule-method}
\title{Origin of rules}
\usage{
origin(x, ...)

\S4method{origin}{rule}(x, ...)

\S4method{origin}{expressionset}(x, ...)
}
\arguments{
\item{x}{and R object}

\item{...}{Arguments to be passed to other methods}
}
\value{
A \code{character} vector.
}
\description{
Origin of rules
}
\section{Methods (by class)}{
\itemize{
\item \code{expressionset}: Origin of every rule in \code{x}
}}
\examples{

# retrieve properties
v <- validator(turnover > 0, staff.costs>0)

# number of rules in v:
length(v)

# per-rule
created(v)
origin(v)
names(v)

# set properties
names(v)[1] <- "p1"

label(v)[1] <- "turnover positive"
description(v)[1] <- "
According to the official definition,
only positive values can be considered
valid turnovers.
"

# short description is also printed:
v

# print all info for first rule
v[[1]]


}
\seealso{
\itemize{
\item{\code{\link{names,expressionset-method}}, \code{\link{length,expressionset-method}}}
\item{\code{\link{description}}, \code{\link{label}}, \code{\link{created}}, \code{\link{variables}}}
}
}

