% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{pcut_threshold}
\alias{pcut_threshold}
\alias{pcut_threshold.default}
\alias{pcut_threshold.mlresult}
\title{Proportional Thresholding (PCut)}
\usage{
pcut_threshold(prediction, ratio, probability = FALSE)

\method{pcut_threshold}{default}(prediction, ratio, probability = FALSE)

\method{pcut_threshold}{mlresult}(prediction, ratio, probability = FALSE)
}
\arguments{
\item{prediction}{A matrix or mlresult.}

\item{ratio}{A single value between 0 and 1 or a list with ratio values
contained one value per label.}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.
(Default: \code{FALSE})}
}
\value{
A mlresult object.
}
\description{
Define the proportion of examples for each label will be positive.
The Proportion Cut (PCut) method can be a label-wise or global method that
calibrates the threshold(s) from the training data globally or per label.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Proportional Thresholding (PCut) method for matrix

\item \code{mlresult}: Proportional Thresholding (PCut) for mlresult
}}

\examples{
prediction <- matrix(runif(16), ncol = 4)
pcut_threshold(prediction, .45)
}
\references{
Al-Otaibi, R., Flach, P., & Kull, M. (2014). Multi-label Classification: A
 Comparative Study on Threshold Selection Methods. In First International
 Workshop on Learning over Multiple Contexts (LMCE) at ECML-PKDD 2014.

Largeron, C., Moulin, C., & Gery, M. (2012). MCut: A Thresholding Strategy
 for Multi-label Classification. In 11th International Symposium, IDA 2012
 (pp. 172-183).
}
\seealso{
Other threshold: 
\code{\link{fixed_threshold}()},
\code{\link{lcard_threshold}()},
\code{\link{mcut_threshold}()},
\code{\link{rcut_threshold}()},
\code{\link{scut_threshold}()},
\code{\link{subset_correction}()}
}
\concept{threshold}
