% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_brplus.R
\name{brplus}
\alias{brplus}
\title{BR+ or BRplus for multi-label Classification}
\usage{
brplus(
  mdata,
  base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{BRPmodel} containing the set of fitted
 models, including:
 \describe{
   \item{freq}{The label frequencies to use with the 'Stat' strategy}
   \item{initial}{The BR model to predict the values for the labels to
     initial step}
   \item{models}{A list of final models named by the label names.}
 }
}
\description{
Create a BR+ classifier to predict multi-label data. This is a simple approach
that enables the binary classifiers to discover existing label dependency by
themselves. The main idea of BR+ is to increment the feature space of the
binary classifiers to let them discover existing label dependency by
themselves.
}
\details{
This implementation has different strategy to predict the final set of labels
for unlabeled examples, as proposed in original paper.
}
\examples{
# Use SVM as base algorithm
model <- brplus(toyml, "RANDOM")
pred <- predict(model, toyml)

\donttest{
# Use Random Forest as base algorithm and 2 cores
model <- brplus(toyml, 'RF', cores = 2, seed = 123)
}
}
\references{
Cherman, E. A., Metz, J., & Monard, M. C. (2012). Incorporating label
   dependency into the binary relevance framework for multi-label
   classification. Expert Systems with Applications, 39(2), 1647-1655.
}
\seealso{
Other Transformation methods: 
\code{\link{br}()},
\code{\link{cc}()},
\code{\link{clr}()},
\code{\link{dbr}()},
\code{\link{ebr}()},
\code{\link{ecc}()},
\code{\link{eps}()},
\code{\link{esl}()},
\code{\link{homer}()},
\code{\link{lift}()},
\code{\link{lp}()},
\code{\link{mbr}()},
\code{\link{ns}()},
\code{\link{ppt}()},
\code{\link{prudent}()},
\code{\link{ps}()},
\code{\link{rakel}()},
\code{\link{rdbr}()},
\code{\link{rpc}()}

Other Stacking methods: 
\code{\link{mbr}()}
}
\concept{Stacking methods}
\concept{Transformation methods}
