% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate.R
\name{tabulate_model}
\alias{tabulate_model}
\title{tabulate_model}
\usage{
tabulate_model(fit, ...)
}
\arguments{
\item{fit}{Required. survival::survfit() or survival::coxph() objects.}

\item{...}{Optional. Miscellaneous parameters. Currently, only digits
and p.digits are used right now in the coxph method.}
}
\value{
Returns tibble containing:
  \item{survfit()}{Graphable survival fit data for use
  in graphing packages.}
  \item{coxph()}{Organized parameters, levels, HR, intervals, and tests.}
}
\description{
Returns tabulated data from a model object. Useful for
graphing a fit or creating a useable coefficient table.
}
\note{
survfit() methods adapted by the 'survminer' package function
surv_summary() [GLP-2].
}
\examples{
library(dplyr)
library(survival)

data_cgd <- as_tibble(cgd)

# Survfit Object
tabulate_model(survfit(Surv(tstart, tstop, status) ~ sex, data = data_cgd))

# Coxph Object
tabulate_model(coxph(Surv(tstart, tstop, status) ~ age + center + sex, data = data_cgd))
}
