% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{use_github}
\alias{use_github}
\title{Connect a local repo with GitHub}
\usage{
use_github(organisation = NULL, private = FALSE, protocol = c("ssh",
  "https"), credentials = NULL, auth_token = NULL, host = NULL)
}
\arguments{
\item{organisation}{If supplied, the repo will be created under this
organisation. You must have access to create repositories.}

\item{private}{If \code{TRUE}, creates a private repository.}

\item{protocol}{transfer protocol, either "ssh" (the default) or "https"}

\item{credentials}{A \code{\link[git2r:cred_ssh_key]{git2r::cred_ssh_key()}} specifying specific ssh
credentials or \code{NULL} for default ssh key and ssh-agent behaviour.}

\item{auth_token}{Provide a personal access token (PAT) from
\url{https://github.com/settings/tokens}. If \code{NULL}, will use the logic
described in \code{\link[gh:gh_whoami]{gh::gh_whoami()}} to look for a token stored in an environment
variable. Use \code{\link[=browse_github_pat]{browse_github_pat()}} to help set up your PAT.}

\item{host}{GitHub API host to use. Override with the endpoint-root for your
GitHub enterprise instance, for example,
"https://github.hostname.com/api/v3"}
}
\description{
\code{use_github()} takes a local project, creates an associated repo on GitHub,
adds it to your local repo as the \code{origin} remote, and makes an initial push
to synchronize. \code{use_github()} requires that your project already be a Git
repository, which you can accomplish with \code{\link[=use_git]{use_git()}}, if needed. See the
Authentication section below for other necessary setup.
}
\section{Authentication}{

A new GitHub repo will be created via the GitHub API, therefore you must
make a \href{https://github.com/settings/tokens}{GitHub personal access token (PAT)} available. You can either
provide this directly via the \code{auth_token} argument or store it in an
environment variable. Use \code{\link[=browse_github_pat]{browse_github_pat()}} to get help obtaining and
storing your PAT. See \code{\link[gh:gh_whoami]{gh::gh_whoami()}} for even more detail.

The argument \code{protocol} specifies the transport protocol you wish to use for
this repo in the long run. This determines the form of the URL for the
\code{origin} remote:
\itemize{
\item \code{protocol = "ssh"}: \code{git@github.com:<OWNER>/<REPO>.git}
\item \code{protocol = "https"}: \code{https://github.com/<OWNER>/<REPO>.git}
}

For \code{protocol = "ssh"}, it is assumed that public and private keys are in the
default locations, \code{~/.ssh/id_rsa.pub} and \code{~/.ssh/id_rsa}, respectively, and
that \code{ssh-agent} is configured to manage any associated passphrase.
Alternatively, specify a \code{\link[git2r:cred_ssh_key]{git2r::cred_ssh_key()}} object via the \code{credentials}
parameter. Read more about ssh setup in \href{http://happygitwithr.com/ssh-keys.html}{Happy Git}, especially the \href{http://happygitwithr.com/ssh-keys.html#ssh-troubleshooting}{troubleshooting section}.
}

\examples{
\dontrun{
pkgpath <- file.path(tempdir(), "testpkg")
create_package(pkgpath) # creates package below temp directory

## now, working inside "testpkg", initialize git repository
use_git()

## create github repository and configure as git remote
use_github()                   ## to use default ssh protocol
use_github(protocol = "https") ## to use https
}
}
