% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_retrieve_clicks}
\alias{bitly_retrieve_clicks}
\title{Get Clicks for a Bitlink}
\usage{
bitly_retrieve_clicks(
  bitlink = NULL,
  size = 50,
  unit_reference = NULL,
  unit = NULL,
  units = -1,
  showRequestURL = FALSE
)
}
\arguments{
\item{bitlink}{- required, a Bitlink made of the domain and hash}

\item{size}{- The quantity of items to be be returned}

\item{unit_reference}{- string | An ISO-8601 timestamp, indicating the most recent time for
which to pull metrics. Will default to current time.}

\item{unit}{- A unit of time}

\item{units}{- An integer representing the time units to query data for. pass -1 to return all units of time.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug
purposes.}
}
\description{
See \url{https://dev.bitly.com/api-reference/#getClicksForBitlink}
This will return the click counts for a specified Bitlink. This returns an array with clicks based on a date.
}
\examples{
\dontrun{
bitly_retrieve_clicks(bitlink = "cnn.it/2HomWGB", unit = "day", units = -1, size = 100)
}
}
