# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Escape characters for use in URLs.
#'
#' @description This function encodes a character vector for use in URLs, escaping all special characters
#' except for those specified in the `safe` parameter.
#'
#' @param urls A character vector to be encoded/decoded.
#' @param safe A character vector of extra characters that should not be encoded.
#'
#' @return A character vector with the encoded URLs.
#'
#' @examples
#' library(urlparse)
#'
#' # Example 1:
#' url_encoder("foo = bar + 5")
#'
#' # Example 2:
#' # prevent special characters being encoded:
#' url <- "https://example.com/path?query= 1+2"
#' url_encoder(url, ":/?=")
#'
#' # Example 3:
#' url_decoder(url_encoder("foo = bar + 5"))
#'
#' @name encoding
#' @export
#' @useDynLib urlparse _urlparse_url_encoder
#' @importFrom Rcpp evalCpp
url_encoder <- function(urls, safe = "") {
    .Call('_urlparse_url_encoder', PACKAGE = 'urlparse', urls, safe)
}

#' @rdname encoding
#' @export
#' @useDynLib urlparse _urlparse_url_decoder
#' @importFrom Rcpp evalCpp
url_decoder <- function(urls) {
    .Call('_urlparse_url_decoder', PACKAGE = 'urlparse', urls)
}

#' Parses a URL string into its components.
#'
#' @param url The URL string to parse.
#'
#' @return
#' A list containing the components of the URL: scheme, user, password, host, path, raw_path, query, raw_query, and fragment.
#'
#' @examples
#' library(urlparse)
#' url_parse("https://host.com/path?query#fragment")
#'
#' @export
#' @useDynLib urlparse _urlparse_url_parse
#' @importFrom Rcpp evalCpp
url_parse <- function(url) {
    .Call('_urlparse_url_parse', PACKAGE = 'urlparse', url)
}

#' @title Builds a URL string from its components.
#'
#' @param url_components A list containing the components of the URL: scheme, host, port, path, query, and fragment.
#' - **scheme** A character string for the new scheme (e.g., "http" or "https") or `NULL` to keep it unchanged.
#' - **host** A character string for the new host or `NULL` to keep it unchanged.
#' - **port** A character string for the new port or `NULL` to keep it unchanged.
#' - **path** A character string for the new path or `NULL` to keep it unchanged.
#' - **query** A list or character of new query parameters or `NULL` to keep it unchanged.
#' - **fragment** A character string for the new fragment or `NULL` to keep it unchanged.
#'
#' @return A URL string constructed from the provided components
#'
#' @examples
#' library(urlparse)
#' url_build(list(
#'   scheme = "https",
#'   user = "",
#'   password = "",
#'   host = "host.com",
#'   port = 8000,
#'   path = "/path",
#'   query = "query",
#'   fragment = "fragment"
#' ))
#'
#' @export
#' @useDynLib urlparse _urlparse_url_build
#' @importFrom Rcpp evalCpp
url_build <- function(url_components) {
    .Call('_urlparse_url_build', PACKAGE = 'urlparse', url_components)
}

#' @title Modifies a URL string by updating its components.
#'
#' @description
#' This function modifies a URL string by updating its components such as scheme, user, password, host, port, query, raw query, and fragment.
#' If any of these components are not provided (i.e., `NULL`), the existing components of the URL are retained.
#'
#' @param url A character string representing the original URL.
#' @param scheme A character string for the new scheme (e.g., "http" or "https") or `NULL` to keep it unchanged.
#' @param user A character string for the username or `NULL` to keep it unchanged.
#' @param password A character string for the new password or `NULL` to keep it unchanged.
#' @param host A character string for the new host or `NULL` to keep it unchanged.
#' @param port A character string for the new port or `NULL` to keep it unchanged.
#' @param path A character string for the new path or `NULL` to keep it unchanged.
#' @param query A list or character of new query parameters or `NULL` to keep it unchanged.
#' @param fragment A character string for the new fragment or `NULL` to keep it unchanged.
#'
#' @return
#' A character string representing the modified URL.
#'
#' @examples
#' library(urlparse)
#'
#' # Example 1: Modify the scheme and host of a URL
#' url_modify(
#'   "https://user:pass@host.com/path?query#fragment",
#'   scheme = "http",
#'   host = "example.com"
#' )
#'
#' # Example 2: Add a query parameter to a URL
#' url_modify(
#'   "https://host.com/path", query = list(key1 = "value1", key2 = "value2")
#' )
#'
#' # Example 3: Change the fragment of a URL
#' url_modify("https://host.com/path#old_fragment", fragment = "new_fragment")
#'
#' @name url_modify
#' @export
#' @useDynLib urlparse _urlparse_url_modify
#' @importFrom Rcpp evalCpp
url_modify <- function(url, scheme = NULL, user = NULL, password = NULL, host = NULL, port = NULL, path = NULL, query = NULL, fragment = NULL) {
    .Call('_urlparse_url_modify', PACKAGE = 'urlparse', url, scheme, user, password, host, port, path, query, fragment)
}

#' @rdname url_modify
#' @export
#' @useDynLib urlparse _urlparse_set_scheme
#' @importFrom Rcpp evalCpp
set_scheme <- function(url, scheme) {
    .Call('_urlparse_set_scheme', PACKAGE = 'urlparse', url, scheme)
}

#' @rdname url_modify
#' @export
#' @useDynLib urlparse _urlparse_set_host
#' @importFrom Rcpp evalCpp
set_user <- function(url, user) {
    .Call('_urlparse_set_user', PACKAGE = 'urlparse', url, user)
}

#' @rdname url_modify
#' @export
#' @useDynLib urlparse _urlparse_set_host
#' @importFrom Rcpp evalCpp
set_password <- function(url, password) {
    .Call('_urlparse_set_password', PACKAGE = 'urlparse', url, password)
}

#' @rdname url_modify
#' @export
#' @useDynLib urlparse _urlparse_set_host
#' @importFrom Rcpp evalCpp
set_host <- function(url, host) {
    .Call('_urlparse_set_host', PACKAGE = 'urlparse', url, host)
}

#' @rdname url_modify
#' @export
#' @useDynLib urlparse _urlparse_set_port
#' @importFrom Rcpp evalCpp
set_port <- function(url, port) {
    .Call('_urlparse_set_port', PACKAGE = 'urlparse', url, port)
}

#' @rdname url_modify
#' @export
#' @useDynLib urlparse _urlparse_set_port
#' @importFrom Rcpp evalCpp
set_path <- function(url, path) {
    .Call('_urlparse_set_path', PACKAGE = 'urlparse', url, path)
}

#' @rdname url_modify
#' @export
#' @useDynLib urlparse _urlparse_set_query
#' @importFrom Rcpp evalCpp
set_query <- function(url, query) {
    .Call('_urlparse_set_query', PACKAGE = 'urlparse', url, query)
}

#' @rdname url_modify
#' @export
#' @useDynLib urlparse _urlparse_set_fragment
#' @importFrom Rcpp evalCpp
set_fragment <- function(url, fragment) {
    .Call('_urlparse_set_fragment', PACKAGE = 'urlparse', url, fragment)
}

