% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-chains.R
\name{split_chains}
\alias{split_chains}
\title{Split Chains}
\usage{
split_chains(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
The modified object.
}
\description{
Splits each of an MCMC object's chains in half
to double the number of chains
and halve the number of iterations.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

nlists <- nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7)))
nchains(nlists)
nchains(split_chains(nlists))
\dontshow{\}) # examplesIf}
}
\seealso{
Other MCMC manipulations: 
\code{\link{bind_chains}()},
\code{\link{collapse_chains}()},
\code{\link{estimates}()}
}
\concept{MCMC manipulations}
