#' Mortality data from ancient Egypt
#'
#' Age at death of 141 Roman era Egyptian mummies.
#'
#' This data was collected by Spiegelberg (1901) and analyzed by Karl Pearson
#'    (1902) in the first volume of Biometrika. It was analyzed by
#'    Claeskens & Hjort (2008) and the data is based on their transcription.
#'
#' @seealso The source of the data is
#' <https://feb.kuleuven.be/public/u0043181/modelselection/datasets/egyptlives_data.txt>
#'
#' @format A [tibble][tibble::tibble] with 141 observations and 2 variables:
#'   \describe{
#'     \item{age}{Age at death.}
#'     \item{sex}{Sex of deceased; 82 males and 49 females.}
#'   }
#'
#' @references
#'   Spiegelberg, W. (1901). Aegyptische und Griechische Eigennamen aus
#'   Mumientiketten der Römischen Kaiserzeit.
#'
#'   Pearson, K. (1902). On the change in expectation of life in man during a
#'   period of circa 2000 years. Biometrika, 1(2), 261-264.
#'
#'   Claeskens, G., & Hjort, N. L. (2008). Model selection and model averaging.
#'   Cambridge University Press.
#' @examples
#' egypt
"egypt"
