% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr-johnsonsb.R
\name{johnsonsb}
\alias{johnsonsb}
\alias{djohnsonsb}
\alias{pjohnsonsb}
\alias{qjohnsonsb}
\alias{rjohnsonsb}
\title{The Johnson SB distribution}
\usage{
djohnsonsb(x, mu, theta, tau = 0.5, log = FALSE)

pjohnsonsb(q, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

qjohnsonsb(p, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

rjohnsonsb(n, mu, theta, tau = 0.5)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{mu}{location parameter indicating the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.}

\item{theta}{nonnegative shape parameter.}

\item{tau}{the parameter to specify which quantile is to used.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq{x})} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{djohnsonsb} gives the density, \code{pjohnsonsb} gives the distribution function,
\code{qjohnsonsb} gives the quantile function and \code{rjohnsonsb} generates random deviates.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function and random number generation function
for the Johnson SB distribution reparametrized in terms of the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.
}
\details{
Probability density function
\deqn{f(y\mid \alpha ,\theta )=\frac{\theta }{\sqrt{2\pi }}\frac{1}{y(1-y)}\exp\left\{ -\frac{1}{2}\left[\alpha +\theta \log\left(\frac{y}{1-y}\right)\right] ^{2}\right\}}

Cumulative distribution function
\deqn{F(y\mid \alpha ,\theta )=\Phi \left[ \alpha +\theta \log \left( \frac{y}{1-y}\right) \right]}

Quantile function
\deqn{Q(\tau \mid \alpha ,\theta )=\frac{\exp \left[ \frac{\Phi ^{-1}(\tau)-\alpha }{\theta }\right] }{1+\exp \left[ \frac{\Phi ^{-1}(\tau )-\alpha }{\theta }\right] }}

Reparameterization
\deqn{\alpha =g^{-1}(\mu )=\Phi ^{-1}(\tau )-\theta \log \left( \frac{\mu }{1-\mu }\right)}
}
\examples{

set.seed(123)
x <- rjohnsonsb(n = 1000, mu = 0.5, theta = 1.5, tau = 0.5)
R <- range(x)
S <- seq(from = R[1], to = R[2], by =  0.01)
hist(x, prob = TRUE, main = 'Johnson SB')
lines(S, djohnsonsb(x = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)
plot(ecdf(x))
lines(S, pjohnsonsb(q = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)
plot(quantile(x, probs = S), type = "l")
lines(qjohnsonsb(p = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)

}
\references{
Lemonte, A. J. and Bazán, J. L., (2015). New class of Johnson SB distributions and its associated regression model for rates and proportions. \emph{Biometrical Journal}, \bold{58}(4), 727--746.

Johnson, N. L., (1949). Systems of frequency curves generated by methods of translation. \emph{Biometrika}, \bold{36}(1), 149--176.
}
\author{
Josmar Mazucheli

André F. B. Menezes
}
