% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umx_r_test}
\alias{umx_r_test}
\title{Test the difference between correlations for significance.}
\usage{
umx_r_test(
  data = NULL,
  vars = vars,
  alternative = c("two.sided", "greater", "less")
)
}
\arguments{
\item{data}{The dataset.}

\item{vars}{Three or 4 variables forming the two pairs of columns.}

\item{alternative}{A two (default) or one-sided (greater less) test.}
}
\value{
cocor result.
}
\description{
\code{umx_r_test} is a wrapper around the cocor test of difference between correlations.
}
\details{
\strong{Non-overlapping (no variable in common) correlations in the same dataset.}
If 4 variables are provided in \code{vars}, \code{umx_r_test} conducts a test of
the correlation of var 1 & 2 differs in magnitude from the correlation of var 3 with var 4.
(\code{r.jk} and \code{r.hm} in cocor speak).

\strong{Overlapping (1 variable in common) correlations in the same dataset.}
If 3 variables are provided in \code{vars}, \code{umx_r_test} conducts a test of whether
the correlation of var 1 & 2 differs in magnitude from the correlation of var 1 with var 3.
(\code{r.jk} and \code{r.jh} in cocor speak).

In the future it will be expanded to handle other correlations, and to take correlations as input.
}
\examples{
# Is the correlation of mpg with cylinder count different from that 
# obtaining between disp and hp?
vars = c("mpg", "cyl", "disp", "hp")
umx_r_test(mtcars, vars)
umx_r_test(mtcars, c("mpg", "disp", "hp"))
}
\seealso{
Other Miscellaneous Stats Helpers: 
\code{\link{FishersMethod}()},
\code{\link{SE_from_p}()},
\code{\link{geometric_mean}()},
\code{\link{harmonic_mean}()},
\code{\link{oddsratio}()},
\code{\link{reliability}()},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umxWeightedAIC}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_means}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()},
\code{\link{umx}}
}
\concept{Miscellaneous Stats Helpers}
