% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxAlgebra}
\alias{umxAlgebra}
\title{A simple wrapper for mxAlgebra with name as the first parameter for more readable compact code.}
\usage{
umxAlgebra(
  name = NA,
  expression,
  dimnames = NA,
  ...,
  joinKey = as.character(NA),
  joinModel = as.character(NA),
  verbose = 0L,
  initial = matrix(as.numeric(NA), 1, 1),
  recompute = c("always", "onDemand"),
  fixed = "deprecated_use_recompute"
)
}
\arguments{
\item{name}{The name of the algebra (Default = NA). Note the different order compared to mxAlgebra!}

\item{expression}{The algebra}

\item{dimnames}{Dimnames of the algebra}

\item{...}{Other parameters}

\item{joinKey}{See mxAlgebra documentation}

\item{joinModel}{See mxAlgebra documentation}

\item{verbose}{Quiet or informative}

\item{initial}{See mxAlgebra documentation}

\item{recompute}{See mxAlgebra documentation}

\item{fixed}{= See mxAlgebra documentation}
}
\value{
\itemize{
\item \code{\link[=mxAlgebra]{mxAlgebra()}}
}
}
\description{
umxAlgebra is a wrapper for mxAlgebra which has the name parameter first in order.
}
\examples{
x = umxAlgebra("circ", 2 * pi)
class(x$formula)
x = mxAlgebra(name = "circ", 2 * pi)
class(x$formula) # "call"

}
\seealso{
\itemize{
\item \code{\link[=umxMatrix]{umxMatrix()}}
}

Other Advanced Model Building Functions: 
\code{\link{umxFixAll}()},
\code{\link{umxJiggle}()},
\code{\link{umxRun}()},
\code{\link{umxThresholdMatrix}()},
\code{\link{umxUnexplainedCausalNexus}()},
\code{\link{umx}},
\code{\link{xmuLabel}()},
\code{\link{xmuValues}()}
}
\concept{Advanced Model Building Functions}
