% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxMI}
\alias{umxMI}
\title{Report modifications which would improve fit.}
\usage{
umxMI(
  model = NA,
  matrices = NA,
  full = TRUE,
  numInd = NA,
  typeToShow = "both",
  decreasing = TRUE
)
}
\arguments{
\item{model}{An \code{\link[=mxModel]{mxModel()}} for which to report modification indices}

\item{matrices}{which matrices to test. The default (NA) will test A & S for RAM models}

\item{full}{Change in fit allowing all parameters to move. If FALSE only the parameter under test can move.}

\item{numInd}{How many modifications to report. Use -1 for all. Default (NA) will report all over 6.63 (p = .01)}

\item{typeToShow}{Whether to shown additions or deletions (default = "both")}

\item{decreasing}{How to sort (default = TRUE, decreasing)}
}
\description{
This function uses the mechanical modification-indices approach to detect single paths which, if added
or dropped, would improve fit.
}
\details{
Notes:
\enumerate{
\item Runs much faster with full = FALSE (but this does not allow the model to re-fit around the newly-
freed parameter).
\item Compared to mxMI, this function returns top changes, and also suppresses the run message.
\item Finally, of course: see the requirements for (legitimate) post-hoc modeling in \code{\link[=mxMI]{mxMI()}}
You are almost certainly doing better science when testing competing models rather than modifying a model to fit.
}
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)
# umxMI(m1, full=FALSE)
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=mxMI]{mxMI()}}
}

Other Modify or Compare Models: 
\code{\link{umxCompare}()},
\code{\link{umxEquate}()},
\code{\link{umxFixAll}()},
\code{\link{umxModify}()},
\code{\link{umxSetParameters}()},
\code{\link{umxUnexplainedCausalNexus}()},
\code{\link{umx}}
}
\concept{Modify or Compare Models}
