% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxReduceACE}
\alias{umxReduceACE}
\title{Reduce an ACE model.}
\usage{
umxReduceACE(
  model,
  report = c("markdown", "inline", "html", "report"),
  baseFileName = "tmp",
  intervals = TRUE,
  ...
)
}
\arguments{
\item{model}{an ACE or ADE \code{\link[=mxModel]{mxModel()}} to reduce}

\item{report}{How to report the results. "html" = open in browser}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp")}

\item{intervals}{Recompute CIs (if any included) on the best model (default = TRUE)}

\item{...}{Other parameters to control model summary}
}
\value{
Best fitting model
}
\description{
This function can perform model reduction on \code{\link[=umxACE]{umxACE()}} models,
testing dropping A and C, as well as an ADE or ACE model, displaying the results
in a table, and returning the best model.
}
\details{
It is designed for testing univariate models. You can offer up either the ACE or ADE base model.

Suggestions for more sophisticated automation welcomed!
}
\examples{
\dontrun{
data(twinData)
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "")
m2 = umxReduce(m1)
umxSummary(m2)
m1 = umxACE(selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "", dzCr = .25)
m2 = umxReduce(m1)

}
}
\references{
\itemize{
\item Wagenmakers, E.J., & Farrell, S. (2004). AIC model selection using Akaike weights. \emph{Psychonomic Bulletin and Review}, \strong{11}, 192-196. \doi{10.3758/BF03206482}
}
}
\seealso{
\code{\link[=umxReduceGxE]{umxReduceGxE()}}, \code{\link[=umxReduce]{umxReduce()}}

Other Twin Modeling Functions: 
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxReduce}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEcov}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryCP}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummaryGxE}()},
\code{\link{umxSummaryIP}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
